/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.model.db;

import com.dataiku.fm.model.db.AWSLoadBalancerRule;
import com.dataiku.fm.model.db.AWSLoadBalancerTargetGroup;
import com.dataiku.fm.model.db.LoadBalancerNodeMapping;
import com.dataiku.fm.model.db.LogicalLoadBalancer;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Entity(name="physicalloadbalancer")
public class PhysicalLoadBalancer {
    @Id
    private String id;
    @OneToOne(fetch=FetchType.LAZY)
    private LogicalLoadBalancer logicalLoadBalancer;
    private String awsLoadBalancerARN;
    private String awsListenerARN;
    @OneToMany(mappedBy="physicalLoadBalancer", cascade={CascadeType.ALL})
    private Set<AWSLoadBalancerTargetGroup> targetGroups = new HashSet<AWSLoadBalancerTargetGroup>();
    @OneToMany(mappedBy="physicalLoadBalancer", cascade={CascadeType.ALL})
    private Set<AWSLoadBalancerRule> rules = new HashSet<AWSLoadBalancerRule>();
    private String azureApplicationGatewayId;
    private String azureFMManagedExternalIpId;

    public String getAwsLoadBalancerARN() {
        return this.awsLoadBalancerARN;
    }

    public void setAwsLoadBalancerARN(String awsLoadBalancerARN) {
        this.awsLoadBalancerARN = awsLoadBalancerARN;
    }

    public String getAwsListenerARN() {
        return this.awsListenerARN;
    }

    public void setAwsListenerARN(String awsListenerARN) {
        this.awsListenerARN = awsListenerARN;
    }

    public Map<LoadBalancerNodeMapping, AWSLoadBalancerTargetGroup> getTargetGroupsByNodeMapping() {
        return this.targetGroups.stream().flatMap(group -> group.getLoadBalancerNodeMappings().stream().map(mapping -> new AbstractMap.SimpleEntry<LoadBalancerNodeMapping, AWSLoadBalancerTargetGroup>((LoadBalancerNodeMapping)mapping, (AWSLoadBalancerTargetGroup)group))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void setTargetGroups(Map<LoadBalancerNodeMapping, AWSLoadBalancerTargetGroup> targetGroups) {
        this.targetGroups = new HashSet<AWSLoadBalancerTargetGroup>(targetGroups.values());
    }

    public void addTargetGroup(AWSLoadBalancerTargetGroup targetGroup) {
        this.targetGroups.add(targetGroup);
    }

    public Map<LoadBalancerNodeMapping, AWSLoadBalancerRule> getRulesByNodeMapping() {
        return this.rules.stream().flatMap(rule -> rule.getLoadBalancerNodeMappings().stream().map(mapping -> new AbstractMap.SimpleEntry<LoadBalancerNodeMapping, AWSLoadBalancerRule>((LoadBalancerNodeMapping)mapping, (AWSLoadBalancerRule)rule))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Set<AWSLoadBalancerTargetGroup> getTargetGroups() {
        return this.targetGroups;
    }

    public Set<AWSLoadBalancerRule> getRules() {
        return this.rules;
    }

    public void addRule(AWSLoadBalancerRule rule) {
        this.rules.add(rule);
    }

    public void setRules(Map<LoadBalancerNodeMapping, AWSLoadBalancerRule> rules) {
        this.rules = new HashSet<AWSLoadBalancerRule>(rules.values());
    }

    public LogicalLoadBalancer getLogicalLoadBalancer() {
        return this.logicalLoadBalancer;
    }

    public void setLogicalLoadBalancer(LogicalLoadBalancer logicalLoadBalancer) {
        this.logicalLoadBalancer = logicalLoadBalancer;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAzureApplicationGatewayId() {
        return this.azureApplicationGatewayId;
    }

    public void setAzureApplicationGatewayId(String azureApplicationGatewayId) {
        this.azureApplicationGatewayId = azureApplicationGatewayId;
    }

    public String getAzureFMManagedExternalIpId() {
        return this.azureFMManagedExternalIpId;
    }

    public void setAzureExternalIpId(String azureFMManagedExternalIpId) {
        this.azureFMManagedExternalIpId = azureFMManagedExternalIpId;
    }
}

