/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.model.published;

import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.model.published.CloudTag;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class CloudTagList
extends ArrayList<CloudTag> {
    private static final long serialVersionUID = 8683452581122892189L;

    public CloudTagList() {
    }

    public CloudTagList(Map<String, String> tags) {
        tags.forEach((? super K key, ? super V value) -> this.add(new CloudTag((String)key, Objects.requireNonNullElse(value, ""))));
    }

    public CloudTagList with(String name, String value) {
        this.add(new CloudTag(name, value));
        return this.deduplicate();
    }

    public CloudTagList with(Collection<CloudTag> tags) {
        if (tags != null) {
            this.addAll(tags);
        }
        return this.deduplicate();
    }

    public CloudTag getTag(String name) {
        if (name != null) {
            for (CloudTag cloudTag : this) {
                if (!name.equals(cloudTag.key)) continue;
                return cloudTag;
            }
        }
        return null;
    }

    public boolean hasTag(String name) {
        return this.getTag(name) != null;
    }

    public static CloudTagList fromJSON(String json) {
        if (json == null || !json.startsWith("{")) {
            return new CloudTagList();
        }
        Map map = JSON.parseToMap((String)json);
        ArrayList keys = new ArrayList(map.keySet());
        Collections.sort(keys);
        CloudTagList result = new CloudTagList();
        for (String key : keys) {
            result.add(new CloudTag(key, (String)map.get(key)));
        }
        return result;
    }

    public static String toJSON(CloudTagList cloudTagList) {
        if (cloudTagList == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (CloudTag tag : cloudTagList) {
            if (!StringUtils.isNotBlank((String)tag.key)) continue;
            map.put(tag.key, StringUtils.defaultIfEmpty((String)tag.value, (String)""));
        }
        return JSON.json(map);
    }

    private CloudTagList deduplicate() {
        ArrayList revlist = Lists.newArrayList((Iterable)this);
        Collections.reverse(revlist);
        this.clear();
        for (CloudTag ct : revlist) {
            if (this.hasTag(ct.key)) continue;
            this.add(ct);
        }
        return this;
    }

    public Map<String, String> asMap() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (CloudTag cloudTag : this) {
            if (result.containsKey(cloudTag.key)) {
                throw new IllegalStateException("Duplicate tag: " + cloudTag.key);
            }
            result.put(cloudTag.key, StringUtils.defaultIfEmpty((String)cloudTag.value, (String)""));
        }
        return result;
    }
}

