/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.model.published;

import com.dataiku.fm.model.published.LoadBalancerDTO;
import com.dataiku.fm.server.core.FMFutureResponse;

public class LoadBalancerLogicalStatus {
    public FMFutureResponse job;
    public LogicalStatus state;
    public boolean isActionInProgress;

    public LoadBalancerLogicalStatus(LoadBalancerDTO.PhysicalStatus physicalStatus, FMFutureResponse job) {
        this.job = job;
        this.computeState(physicalStatus);
    }

    public void computeState(LoadBalancerDTO.PhysicalStatus physicalStatus) {
        this.isActionInProgress = this.job != null && this.job.alive;
        this.state = this.isActionInProgress ? this.getStateFromActionInProgress(this.job.action) : this.getStateFromPhysicalStatus(physicalStatus);
    }

    private LogicalStatus getStateFromActionInProgress(FMFutureResponse.Action actionInProgress) {
        switch (actionInProgress) {
            case DELETE: {
                return LogicalStatus.DELETING;
            }
            case DEPROVISION: {
                return LogicalStatus.DEPROVISIONING;
            }
            case PROVISION: {
                return LogicalStatus.PROVISIONING;
            }
            case REPROVISION: {
                return LogicalStatus.REPROVISIONING;
            }
            case UPDATE: {
                return LogicalStatus.UPDATING;
            }
        }
        return null;
    }

    private LogicalStatus getStateFromPhysicalStatus(LoadBalancerDTO.PhysicalStatus physicalStatus) {
        switch (physicalStatus) {
            case PROVISIONING: {
                return LogicalStatus.PROVISIONING;
            }
            case NEED_REPROVISIONING: 
            case NEED_UPDATING: 
            case PROVISIONED: {
                return LogicalStatus.PROVISIONED;
            }
        }
        return LogicalStatus.NOT_PROVISIONED;
    }

    public static enum LogicalStatus {
        PROVISIONING,
        DEPROVISIONING,
        REPROVISIONING,
        UPDATING,
        NOT_PROVISIONED,
        PROVISIONED,
        DELETING;

    }
}

