/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.alerts;

import com.dataiku.fm.model.db.MessagingChannelType;
import com.dataiku.fm.server.alerts.messagebuilders.MessageBuilder;
import com.dataiku.fm.server.alerts.messagebuilders.SMTPV1MessageBuilder;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class CheckReporterService {
    Map<MessageBuilderKey, MessageBuilder> senderMap = CheckReporterService.buildMapKeyedByMessagingChannelType(Set.of(new SMTPV1MessageBuilder()));

    public MessageBuilder getMessageBuilder(MessagingChannelType messagingChannelType, int configurationVersion) {
        return this.senderMap.get(new MessageBuilderKey(messagingChannelType, configurationVersion));
    }

    private static Map<MessageBuilderKey, MessageBuilder> buildMapKeyedByMessagingChannelType(Set<MessageBuilder> messageBuilderSet) {
        return messageBuilderSet.stream().collect(Collectors.toMap(messageBuilder -> new MessageBuilderKey(messageBuilder.getMessagingChannelType(), messageBuilder.getVersion()), Function.identity()));
    }

    record MessageBuilderKey(MessagingChannelType messagingChannelType, int integer) {
    }
}

