/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.alerts;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.model.Utils;
import com.dataiku.fm.model.db.CheckDefinition;
import com.dataiku.fm.model.db.CheckReporter;
import com.dataiku.fm.model.db.CheckState;
import com.dataiku.fm.model.db.ElementCheck;
import com.dataiku.fm.model.db.MessagingChannel;
import com.dataiku.fm.server.alerts.AlertingDBService;
import com.dataiku.fm.server.alerts.CheckDefinitionService;
import com.dataiku.fm.server.notifications.NotificationService;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ElementCheckService {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.alerting.elementCheckService");
    @Autowired
    private AlertingDBService dbService;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private CheckDefinitionService checkDefinitionService;
    private static final int ACCEPTABLE_TIME_DELTA_IN_MS = 500;

    public List<ElementCheck> getEnabledElementChecks() {
        return this.dbService.getAllElementChecksByStatus(true);
    }

    public void performEnabledChecks() {
        this.dbService.getThreadEM().clear();
        List<ElementCheck> enabledElementChecks = this.getEnabledElementChecks();
        for (ElementCheck elementCheck : enabledElementChecks) {
            try {
                boolean result = this.performTypeSafeCheck(elementCheck);
                this.processCheckResult(elementCheck, result);
            }
            catch (Exception e) {
                logger.error((Object)"Exception occurred during check execution: ", (Throwable)e);
            }
        }
    }

    private boolean performTypeSafeCheck(ElementCheck elementCheck) {
        CheckDefinition checkDefinition = elementCheck.getCheckDefinition();
        return this.checkDefinitionService.getChecker(checkDefinition.getType(), checkDefinition.getConfigurationVersion()).check(checkDefinition.getConfiguration(), elementCheck.getElementId(), this.dbService);
    }

    void processCheckResult(ElementCheck elementCheck, boolean checkResult) throws Exception {
        long currentTimestamp = System.currentTimeMillis();
        if (checkResult) {
            switch (elementCheck.getCheckState()) {
                case OK: {
                    break;
                }
                case IN_GRACE_PERIOD: {
                    logger.debug((Object)"Success while in grace period -> to OK");
                    elementCheck.updateState(CheckState.OK, currentTimestamp);
                    this.saveElementCheck(elementCheck);
                    break;
                }
                case KO: {
                    logger.debug((Object)"Success while KO -> to under resolution");
                    elementCheck.updateState(CheckState.UNDER_RESOLUTION, currentTimestamp);
                    this.saveElementCheck(elementCheck);
                    break;
                }
                case UNDER_RESOLUTION: {
                    if (this.isWithinGracePeriod(elementCheck, currentTimestamp)) break;
                    logger.debug((Object)"Still success after resolution period is finished -> to OK");
                    elementCheck.updateState(CheckState.OK, currentTimestamp);
                    this.saveElementCheck(elementCheck);
                    this.sendResolutionNotification(elementCheck);
                }
            }
        } else {
            switch (elementCheck.getCheckState()) {
                case OK: {
                    logger.debug((Object)"Failed while OK -> to in grace period");
                    elementCheck.updateState(CheckState.IN_GRACE_PERIOD, currentTimestamp);
                    this.saveElementCheck(elementCheck);
                    break;
                }
                case IN_GRACE_PERIOD: {
                    if (this.isWithinGracePeriod(elementCheck, currentTimestamp)) break;
                    logger.debug((Object)"Still failed after the grace period is finished -> to KO");
                    elementCheck.updateState(CheckState.KO, currentTimestamp);
                    this.saveElementCheck(elementCheck);
                    this.sendFailureNotification(elementCheck);
                    elementCheck.setLastKoNotificationTimestamp(currentTimestamp);
                    this.saveElementCheck(elementCheck);
                    break;
                }
                case KO: {
                    if (this.isWithinResendNotificationPeriod(elementCheck, currentTimestamp)) break;
                    logger.debug((Object)"Sending another notification as resend notification period is passed");
                    this.sendFailureNotification(elementCheck);
                    elementCheck.setLastKoNotificationTimestamp(currentTimestamp);
                    this.saveElementCheck(elementCheck);
                    break;
                }
                case UNDER_RESOLUTION: {
                    logger.debug((Object)"Failed again while under resolution -> back to KO");
                    elementCheck.updateState(CheckState.KO, currentTimestamp);
                    this.saveElementCheck(elementCheck);
                }
            }
        }
    }

    private boolean isWithinGracePeriod(ElementCheck elementCheck, long currentTimestamp) {
        int gracePeriodInMs = Utils.convertSecondsInMilliseconds(elementCheck.getCheckDefinition().getGracePeriodInSec());
        return currentTimestamp - elementCheck.getLastStatusChangeTimestamp() <= (long)(gracePeriodInMs - 500);
    }

    private boolean isWithinResendNotificationPeriod(ElementCheck elementCheck, long currentTimestamp) {
        if (elementCheck.getLastKoNotificationTimestamp() == null) {
            return false;
        }
        int resendNotificationPeriodInMs = Utils.convertSecondsInMilliseconds(elementCheck.getCheckDefinition().getResendNotificationPeriodInSec());
        return currentTimestamp - elementCheck.getLastKoNotificationTimestamp() <= (long)(resendNotificationPeriodInMs - 500);
    }

    private void sendNotification(ElementCheck elementCheck, NotificationService.NotificationStatus notificationStatus) throws Exception {
        try {
            CheckDefinition checkDefinition = elementCheck.getCheckDefinition();
            if (checkDefinition.getCheckReporters() != null) {
                for (CheckReporter checkReporter : checkDefinition.getCheckReporters()) {
                    if (checkReporter == null || checkReporter.getMessagingChannel() == null) continue;
                    MessagingChannel messagingChannel = checkReporter.getMessagingChannel();
                    this.notificationService.sendNotification(messagingChannel, checkReporter, elementCheck, notificationStatus);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"An error occurred during notification sending", (Throwable)e);
        }
    }

    private void sendFailureNotification(ElementCheck elementCheck) throws Exception {
        logger.debug((Object)("Sending a failure notification for check " + elementCheck.printForLogs()));
        this.sendNotification(elementCheck, NotificationService.NotificationStatus.FAILURE);
    }

    private void sendResolutionNotification(ElementCheck elementCheck) throws Exception {
        logger.debug((Object)("Sending a resolution notification for check " + elementCheck.printForLogs()));
        this.sendNotification(elementCheck, NotificationService.NotificationStatus.RESOLUTION);
    }

    public void saveElementCheck(ElementCheck elementCheck) {
        this.dbService.saveElementCheck(elementCheck);
    }
}

