/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.alerts.checkers;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.model.Utils;
import com.dataiku.fm.model.db.CheckType;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.server.agentapi.AgentAPIController;
import com.dataiku.fm.server.alerts.checkers.LogicalInstanceChecker;

public class LogicalInstanceDataDiskConsumptionV1Checker
extends LogicalInstanceChecker {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.alerting.checker.logicalInstanceDataDiskConsumptionV1");

    @Override
    public boolean check(String configurationAsString, LogicalInstance logicalInstance) {
        Configuration configuration = (Configuration)JSON.parse((String)configurationAsString, Configuration.class);
        if (logicalInstance.getCurrentPhysicalInstance() != null) {
            PhysicalInstance physicalInstance = logicalInstance.getCurrentPhysicalInstance();
            if (physicalInstance.getLastHeartbeatState() == null) {
                return false;
            }
            AgentAPIController.HeartbeatState heartbeatState = Utils.parseHeartbeatState(physicalInstance.getLastHeartbeatState());
            return Utils.computeUsagePercentage(heartbeatState.bytesUsed, heartbeatState.bytesTotal).map(dataDiskUsagePercentage -> {
                logger.debug((Object)("Data disk usage percentage: " + dataDiskUsagePercentage + " ; Threshold: " + configuration.threshold));
                return dataDiskUsagePercentage <= (double)configuration.threshold;
            }).orElse(false);
        }
        return false;
    }

    @Override
    public Class<?> getConfigurationClass() {
        return Configuration.class;
    }

    @Override
    public CheckType getCheckType() {
        return CheckType.LOGICAL_INSTANCE_DATA_DISK_CONSUMPTION;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    private static class Configuration {
        private int threshold;

        private Configuration() {
        }

        public int getThreshold() {
            return this.threshold;
        }
    }
}

