/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.alerts.checkers;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.model.db.CheckType;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.server.alerts.checkers.LogicalInstanceChecker;
import com.dataiku.fm.server.instances.InstancesHelper;
import java.util.Set;

public class LogicalInstanceInvalidStatusV1Checker
extends LogicalInstanceChecker {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.alerting.checker.logicalInstanceInvalidStatusV1");
    private static final Set<PhysicalInstance.LifecycleStage> INVALID_PHYSICAL_INSTANCE_STAGES = Set.of(PhysicalInstance.LifecycleStage.FAILED, PhysicalInstance.LifecycleStage.NOT_RESPONDING);

    @Override
    public boolean check(String configurationAsString, LogicalInstance logicalInstance) {
        if (logicalInstance.getCurrentPhysicalInstance() != null) {
            PhysicalInstance physicalInstance = logicalInstance.getCurrentPhysicalInstance();
            PhysicalInstance.LifecycleStage lifecycleStage = InstancesHelper.computeLifeCycleStage(physicalInstance);
            logger.debug((Object)("Machine status found: " + lifecycleStage.name()));
            return !INVALID_PHYSICAL_INSTANCE_STAGES.contains((Object)lifecycleStage);
        }
        return false;
    }

    @Override
    public Class<?> getConfigurationClass() {
        return Configuration.class;
    }

    @Override
    public CheckType getCheckType() {
        return CheckType.LOGICAL_INSTANCE_INVALID_STATUS;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    private static class Configuration {
        private Configuration() {
        }
    }
}

