/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.alerts.checkers;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.model.Utils;
import com.dataiku.fm.model.db.CheckType;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.server.agentapi.AgentAPIController;
import com.dataiku.fm.server.alerts.checkers.LogicalInstanceChecker;

public class LogicalInstanceOSDiskConsumptionV1Checker
extends LogicalInstanceChecker {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.alerting.checker.logicalInstanceOsDiskConsumptionV1");

    @Override
    public boolean check(String configurationAsString, LogicalInstance logicalInstance) {
        Configuration configuration = (Configuration)JSON.parse((String)configurationAsString, Configuration.class);
        if (logicalInstance.getCurrentPhysicalInstance() != null) {
            PhysicalInstance physicalInstance = logicalInstance.getCurrentPhysicalInstance();
            if (physicalInstance.getLastHeartbeatState() == null) {
                return false;
            }
            AgentAPIController.HeartbeatState heartbeatState = Utils.parseHeartbeatState(physicalInstance.getLastHeartbeatState());
            return Utils.computeUsagePercentage(heartbeatState.osBytesUsed, heartbeatState.osBytesTotal).map(osDiskUsagePercentage -> {
                logger.debug((Object)("Data disk usage percentage: " + osDiskUsagePercentage + " ; Threshold: " + configuration.threshold));
                return osDiskUsagePercentage <= (double)configuration.threshold;
            }).orElse(false);
        }
        return false;
    }

    @Override
    public Class<?> getConfigurationClass() {
        return Configuration.class;
    }

    @Override
    public CheckType getCheckType() {
        return CheckType.LOGICAL_INSTANCE_OS_DISK_CONSUMPTION;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    private static class Configuration {
        private int threshold;

        private Configuration() {
        }

        public int getThreshold() {
            return this.threshold;
        }
    }
}

