/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.alerts.senders;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.integrations.mail.SMTPSender;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.model.db.CheckReporter;
import com.dataiku.fm.model.db.ElementCheck;
import com.dataiku.fm.model.db.MessagingChannel;
import com.dataiku.fm.model.db.MessagingChannelType;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.server.alerts.AlertingUtils;
import com.dataiku.fm.server.alerts.CheckReporterService;
import com.dataiku.fm.server.alerts.messagebuilders.SMTPMessageBuilder;
import com.dataiku.fm.server.alerts.senders.NotificationSender;
import com.dataiku.fm.server.notifications.NotificationService;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;

public class SMTPV1Sender
extends NotificationSender {
    private CheckReporterService checkReporterService;
    private CloudCryptoService cloudCryptoService;
    private freemarker.template.Configuration freemarkerConfiguration;
    private static final Logger logger = Logger.getLogger((String)"dku.fm.alerting.sender.smtpv1");

    public SMTPV1Sender(CheckReporterService checkReporterService, CloudCryptoService cloudCryptoService) {
        this.checkReporterService = checkReporterService;
        this.cloudCryptoService = cloudCryptoService;
        try {
            this.freemarkerConfiguration = new freemarker.template.Configuration(freemarker.template.Configuration.VERSION_2_3_30);
            this.freemarkerConfiguration.setDirectoryForTemplateLoading(DKUApp.getResourceFile((String)"notifications"));
        }
        catch (IOException e) {
            logger.error((Object)"Error while preparing FreeMarker configuration:", (Throwable)e);
        }
    }

    public SMTPSender.SMTPIntegrationChannelConfiguration buildSMTPIntegrationChannelConfiguration(Tenant tenant, String configurationAsString) {
        SMTPSender.SMTPIntegrationChannelConfiguration smtpIntegrationChannelConfiguration = new SMTPSender.SMTPIntegrationChannelConfiguration();
        String decryptedConfiguration = this.decryptConfiguration(tenant, configurationAsString);
        Configuration configuration = (Configuration)JSON.parse((String)decryptedConfiguration, Configuration.class);
        smtpIntegrationChannelConfiguration.useSSL = configuration.useSSL;
        smtpIntegrationChannelConfiguration.useTLS = configuration.useTLS;
        smtpIntegrationChannelConfiguration.login = configuration.login;
        smtpIntegrationChannelConfiguration.password = configuration.password;
        smtpIntegrationChannelConfiguration.host = configuration.host;
        smtpIntegrationChannelConfiguration.port = configuration.port;
        smtpIntegrationChannelConfiguration.sessionProperties = configuration.sessionProperties != null ? configuration.sessionProperties : new ArrayList();
        return smtpIntegrationChannelConfiguration;
    }

    @Override
    public Future<InfoMessage.InfoMessages> sendNotification(ExecutorService executorService, MessagingChannel messagingChannel, CheckReporter checkReporter, ElementCheck elementCheck, NotificationService.NotificationStatus notificationType) throws Exception {
        String subject = this.buildSubject(elementCheck, notificationType);
        String body = this.buildBody(elementCheck, notificationType);
        SMTPSender sender = new SMTPSender(this.buildSMTPIntegrationChannelConfiguration(messagingChannel.getTenant(), messagingChannel.getConfiguration()));
        Session session = sender.newSession();
        Message msg = this.makeMessage(session, subject, body);
        SMTPMessageBuilder smtpMessageBuilder = (SMTPMessageBuilder)this.checkReporterService.getMessageBuilder(checkReporter.getMessagingChannelType(), checkReporter.getConfigurationVersion());
        msg = smtpMessageBuilder.enrichMessage(msg, checkReporter.getConfiguration());
        logger.info((Object)"Message ready to be sent");
        return sender.startSending(executorService, session, msg);
    }

    @Override
    public Class<?> getConfigurationClass() {
        return Configuration.class;
    }

    @Override
    public MessagingChannelType getMessagingChannelType() {
        return MessagingChannelType.SMTP;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public String encryptConfiguration(Tenant tenant, String decryptedConfiguration) {
        Configuration configuration = (Configuration)JSON.parse((String)decryptedConfiguration, Configuration.class);
        configuration.password = configuration.password == null ? null : this.cloudCryptoService.encrypt(tenant, configuration.password);
        return JSON.json((Object)configuration);
    }

    @Override
    public String decryptConfiguration(Tenant tenant, String encryptedConfiguration) {
        Configuration configuration = (Configuration)JSON.parse((String)encryptedConfiguration, Configuration.class);
        configuration.password = this.cloudCryptoService.decrypt(tenant, configuration.password);
        return JSON.json((Object)configuration);
    }

    private String buildSubject(ElementCheck elementCheck, NotificationService.NotificationStatus notificationType) {
        String subjectPattern = switch (notificationType) {
            default -> throw new IncompatibleClassChangeError();
            case NotificationService.NotificationStatus.FAILURE -> "Dataiku Fleet Manager Alert: %s %s";
            case NotificationService.NotificationStatus.RESOLUTION -> "Dataiku Fleet Manager Alert Resolution: %s %s";
        };
        return String.format(subjectPattern, elementCheck.getCheckDefinition().getType().getLabel(), elementCheck.getElementId());
    }

    private String buildBody(ElementCheck elementCheck, NotificationService.NotificationStatus notificationType) {
        HashMap<String, String> templateData = new HashMap<String, String>();
        templateData.put("checkType", elementCheck.getCheckDefinition().getType().getLabel());
        templateData.put("elementType", elementCheck.getElementType().getLabel());
        templateData.put("elementId", elementCheck.getElementId());
        templateData.put("notificationType", notificationType.toString());
        templateData.put("lastStatusChangeTimestamp", AlertingUtils.toPrintedTimestamp(elementCheck.getLastStatusChangeTimestamp()));
        StringWriter writer = new StringWriter();
        try {
            Template template = this.freemarkerConfiguration.getTemplate("fm-alerting-notification-email.ftl");
            template.process(templateData, (Writer)writer);
        }
        catch (TemplateException | IOException e) {
            logger.error((Object)"Failed to process FreeMarker template for email notification", e);
            throw new RuntimeException("Email template processing failed", e);
        }
        return writer.toString();
    }

    private Message makeMessage(Session session, String subject, String body) throws Exception {
        MimeMessage mail = new MimeMessage(session);
        mail.setSubject(subject);
        mail.setContent(this.makeStandardEmailContent(body));
        return mail;
    }

    private Multipart makeStandardEmailContent(String body) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(body, "utf-8", "html");
        multipart.addBodyPart((BodyPart)messageBodyPart);
        return multipart;
    }

    private static class Configuration {
        private boolean useCurrentUserAsSender;
        private String sender;
        private String authorizedDomain;
        private boolean useSSL;
        private boolean useTLS;
        private String login;
        private String password;
        private String host;
        private Integer port;
        private List<SimpleKeyValue> sessionProperties;

        private Configuration() {
        }
    }
}

