/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.core;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.util.HTTPClientUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.model.settings.Cloud;
import com.dataiku.fm.model.settings.InstanceImagesSettings;
import com.dataiku.fm.model.settings.InstanceImagesSettingsRepository;
import com.dataiku.fm.server.FMApp;
import java.io.IOException;
import java.util.HashMap;
import javax.annotation.PostConstruct;

public class CloudDataSyncService {
    public static final long INITIAL_DELAY_MS = FMApp.getParams().getLongParam("dku.fm.clouddata.initialFetchDelayS", 20L) * 1000L;
    public static final long SUCCESS_INTERVAL_MS = FMApp.getParams().getLongParam("dku.fm.clouddata.successFetchIntervalS", 43200L) * 1000L;
    public static final long ERROR_INTERVAL_MS = FMApp.getParams().getLongParam("dku.fm.clouddata.failedFetchIntervalS", 7200L) * 1000L;
    public static final String DEFAULT_BASE_URL = "https://downloads.dataiku.com/public/fm/$FM_VERSION";
    private final FetchThread fetchThread = new FetchThread();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.clouddata");

    private static String getFileName(Cloud cloud) {
        return cloud.name().toLowerCase() + "-instance-images.json";
    }

    private static String getURL(Cloud cloud) {
        return FMApp.getProperty((String)"dku.fm.clouddata.baseurl", (String)DEFAULT_BASE_URL).replace("$FM_VERSION", FMApp.getDSSVersion().product_version) + "/" + cloud.instanceImagesFilename;
    }

    @PostConstruct
    public void start() throws IOException {
        if (FMApp.getFMSettingsUnsafe().autoRefreshInstanceImages) {
            logger.info((Object)"Starting instance images fetch thread");
            this.fetchThread.start();
        } else {
            logger.info((Object)"Not starting instance images fetch thread (disabled by configuration)");
        }
    }

    public void forceImmediateRefresh() {
        this.fetchThread.forceImmediateRefresh();
    }

    private void fetchAndUpdate() throws IOException {
        ProxySettings proxySettings = FMApp.getFMSettingsUnsafe().proxySettings;
        String url = CloudDataSyncService.getURL(FMApp.getFMSettingsUnsafe().cloud);
        try {
            logger.info((Object)("Fetching new instance images from " + url));
            InstanceImagesSettings iis = (InstanceImagesSettings)HTTPClientUtils.getFromJSON_GET((String)url, InstanceImagesSettings.class, new HashMap(), (ProxySettings)proxySettings);
            logger.info((Object)"Successfully downloaded new instance images");
            InstanceImagesSettingsRepository.of(FMApp.getFMSettingsUnsafe().cloud).update(iis);
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to fetch new instance images", (Throwable)e);
            throw e;
        }
    }

    private class FetchThread
    extends Thread {
        private FetchThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                Thread.sleep(INITIAL_DELAY_MS);
                while (true) {
                    try {
                        while (true) {
                            CloudDataSyncService.this.fetchAndUpdate();
                            FetchThread fetchThread = this;
                            synchronized (fetchThread) {
                                this.wait(SUCCESS_INTERVAL_MS);
                            }
                        }
                    }
                    catch (IOException e) {
                        FetchThread fetchThread = this;
                        synchronized (fetchThread) {
                            this.wait(ERROR_INTERVAL_MS);
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                logger.error((Object)"Instances data fetch thread was interrupted", (Throwable)e);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forceImmediateRefresh() {
            logger.info((Object)"Forcing images list fetch thread to resume");
            FetchThread fetchThread = this;
            synchronized (fetchThread) {
                this.notify();
            }
        }
    }
}

