/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.instances;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.com.google.common.collect.HashMultimap;
import com.dataiku.dss.shadelib.com.google.common.collect.Multimap;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.model.SetupAction;
import com.dataiku.fm.model.db.InstanceSettingsTemplate;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.published.InstanceSettingsTemplateDTO;
import com.dataiku.fm.model.published.UpdateAction;
import com.dataiku.fm.server.instances.JSonHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

class InstanceSettingsTemplateUpdater {
    private final CloudCryptoService cryptoService;
    public InstanceSettingsTemplate ist;
    public UpdateAction requiresAction = UpdateAction.NO_ACTION_REQUIRED;

    public InstanceSettingsTemplateUpdater(CloudCryptoService cryptoService, InstanceSettingsTemplate ist) {
        this.cryptoService = cryptoService;
        this.ist = ist;
    }

    public void update(AuthCtx authCtx, Tenant tenant, InstanceSettingsTemplateDTO dto) {
        this.ist.setLabel(InstanceSettingsTemplateUpdater.withDefaultInstanceSettingsTemplateLabel(authCtx, dto.label));
        this.ist.setDescription(dto.description);
        this.ist.setSetupActions(this.processSetupActions(this.ist.getSetupActions(), dto.setupActions));
        this.ist.setAwsKeyPairName(this.process(this.ist.getAwsKeyPairName(), dto.awsKeyPairName, UpdateAction.REQUIRES_REPROVISION));
        this.ist.setAzureSshKey(this.process(this.ist.getAzureSshKey(), dto.azureSshKey, UpdateAction.REQUIRES_REPROVISION));
        this.ist.setLicense(this.process(this.ist.getLicense(), dto.license, UpdateAction.REQUIRES_REBOOT));
        this.ist.setStartupInstanceProfileArn(this.process(this.ist.getStartupInstanceProfileArn(), dto.startupInstanceProfileArn, UpdateAction.REQUIRES_REPROVISION));
        this.ist.setRuntimeInstanceProfileArn(this.process(this.ist.getRuntimeInstanceProfileArn(), dto.runtimeInstanceProfileArn, UpdateAction.REQUIRES_REPROVISION));
        this.ist.setStartupManagedIdentity(this.process(this.ist.getStartupManagedIdentity(), dto.startupManagedIdentity, UpdateAction.REQUIRES_REPROVISION));
        this.ist.setRuntimeManagedIdentity(this.process(this.ist.getRuntimeManagedIdentity(), dto.runtimeManagedIdentity, UpdateAction.REQUIRES_REPROVISION));
        this.ist.setStartupServiceAccount(this.process(this.ist.getStartupServiceAccount(), dto.startupServiceAccount, UpdateAction.REQUIRES_REPROVISION));
        this.ist.setRestrictAwsMetadataServerAccess(this.process(this.ist.isRestrictAwsMetadataServerAccess(), dto.restrictAwsMetadataServerAccess, UpdateAction.REQUIRES_REPROVISION));
        this.ist.setRestrictGcpMetadataServerAccess(this.process(this.ist.isRestrictGcpMetadataServerAccess(), dto.restrictGcpMetadataServerAccess, UpdateAction.REQUIRES_REPROVISION));
        this.ist.setGcpSshKey(this.process(this.ist.getGcpSshKey(), dto.gcpSshKey, UpdateAction.REQUIRES_REPROVISION));
        this.ist.setGcpBlockProjectWideKeys(this.process(this.ist.isGcpBlockProjectWideKeys(), dto.gcpBlockProjectWideKeys, UpdateAction.REQUIRES_REPROVISION));
        this.ist.setRestrictAzureMetadataServerAccess(this.process(this.ist.isRestrictAzureMetadataServerAccess(), dto.restrictAzureMetadataServerAccess, UpdateAction.REQUIRES_REPROVISION));
        this.ist.setDataikuAWSAPIAccessMode(this.process(this.ist.getDataikuAWSAPIAccessMode(), dto.dataikuAwsAPIAccessMode, UpdateAction.REQUIRES_REPROVISION));
        this.ist.setDataikuAwsKeypairStorageMode(this.process(this.ist.getDataikuAwsKeypairStorageMode(), dto.dataikuAwsKeypairStorageMode, UpdateAction.REQUIRES_REPROVISION));
        this.ist.setDataikuAwsAccessKeyId(this.process(this.ist.getDataikuAwsAccessKeyId(), dto.dataikuAwsAccessKeyId, UpdateAction.REQUIRES_REPROVISION));
        if (StringUtils.isNotBlank((String)dto.dataikuAwsSecretAccessKey) && dto.dataikuAwsKeypairStorageMode == InstanceSettingsTemplate.DataikuAWSKeypairStorageMode.INLINE_ENCRYPTED) {
            String encryptedKey = this.cryptoService.encrypt(tenant, dto.dataikuAwsSecretAccessKey);
            this.ist.setDataikuAwsSecretAccessKey(this.process(this.ist.getDataikuAwsSecretAccessKey(), encryptedKey, UpdateAction.REQUIRES_REPROVISION));
        }
        this.ist.setDataikuAwsSecretAccessKeyAwsSecretName(this.process(this.ist.getDataikuAwsSecretAccessKeyAwsSecretName(), dto.dataikuAwsSecretAccessKeyAwsSecretName, UpdateAction.REQUIRES_REPROVISION));
        this.ist.setDssPort(this.process(this.ist.getDssPort(), dto.dssPort, UpdateAction.REQUIRES_REPROVISION));
        this.ist.setStoriesEnabled(this.process(this.ist.getStoriesEnabled(), dto.storiesEnabled, UpdateAction.REQUIRES_REPROVISION));
    }

    @VisibleForTesting
    String processSetupActions(String currentSetupActions, SetupAction.SetupActionList newActions) {
        SetupAction.SetupActionList currentActions = JSonHelper.parseJsonSetupActions(currentSetupActions);
        this.processSshKeys(currentActions, newActions);
        this.processSystemPackages(currentActions, newActions);
        this.processAnsibleTasks(currentActions, newActions);
        this.processOtherActions(currentActions, newActions);
        return JSonHelper.toJsonString(newActions);
    }

    private void processOtherActions(SetupAction.SetupActionList currentActions, SetupAction.SetupActionList newActions) {
        SetupAction.SetupActionList currentOtherActions = InstanceSettingsTemplateUpdater.filterOtherActions(currentActions);
        SetupAction.SetupActionList newOtherActions = InstanceSettingsTemplateUpdater.filterOtherActions(newActions);
        this.process(JSonHelper.toJsonString(currentOtherActions), JSonHelper.toJsonString(newOtherActions), UpdateAction.REQUIRES_REPROVISION);
    }

    private <T> T process(T currentValue, T newValue, UpdateAction impactOfChange) {
        if (!Objects.equals(currentValue, newValue)) {
            this.requiresAction = this.requiresAction.max(impactOfChange);
        }
        return newValue;
    }

    private void processSshKeys(SetupAction.SetupActionList currentActions, SetupAction.SetupActionList newActions) {
        this.processSets(InstanceSettingsTemplateUpdater.collectSshKeys(currentActions), InstanceSettingsTemplateUpdater.collectSshKeys(newActions), UpdateAction.REQUIRES_REPLAY_SETUP_ACTIONS);
    }

    private void processSystemPackages(SetupAction.SetupActionList currentActions, SetupAction.SetupActionList newActions) {
        this.processSets(InstanceSettingsTemplateUpdater.collectSystemPackages(currentActions), InstanceSettingsTemplateUpdater.collectSystemPackages(newActions), UpdateAction.REQUIRES_REPLAY_SETUP_ACTIONS);
    }

    private void processSets(Set<String> currentItems, Set<String> newItems, UpdateAction impactAddition) {
        if (!newItems.containsAll(currentItems)) {
            this.requiresAction = this.requiresAction.max(UpdateAction.REQUIRES_REPROVISION);
        } else if (!currentItems.containsAll(newItems)) {
            this.requiresAction = this.requiresAction.max(impactAddition);
        }
    }

    private void processAnsibleTasks(SetupAction.SetupActionList currentActions, SetupAction.SetupActionList newActions) {
        Multimap<String, String> currentAnsibleTasks = InstanceSettingsTemplateUpdater.collectAnsibleTasks(currentActions);
        Multimap<String, String> newAnsibleTasks = InstanceSettingsTemplateUpdater.collectAnsibleTasks(newActions);
        this.processSets(InstanceSettingsTemplateUpdater.tasksForStage(currentAnsibleTasks, "before_install"), InstanceSettingsTemplateUpdater.tasksForStage(newAnsibleTasks, "before_install"), UpdateAction.REQUIRES_REPROVISION);
        this.processSets(InstanceSettingsTemplateUpdater.tasksForStage(currentAnsibleTasks, "after_install"), InstanceSettingsTemplateUpdater.tasksForStage(newAnsibleTasks, "after_install"), UpdateAction.REQUIRES_REBOOT);
        this.processSets(InstanceSettingsTemplateUpdater.tasksForStage(currentAnsibleTasks, "after_service_open"), InstanceSettingsTemplateUpdater.tasksForStage(newAnsibleTasks, "after_service_open"), UpdateAction.REQUIRES_REBOOT);
        this.processSets(InstanceSettingsTemplateUpdater.tasksForStage(currentAnsibleTasks, "after_dss_startup"), InstanceSettingsTemplateUpdater.tasksForStage(newAnsibleTasks, "after_dss_startup"), UpdateAction.REQUIRES_REPLAY_SETUP_ACTIONS);
    }

    private static Set<String> tasksForStage(Multimap<String, String> ansibleTasks, String stage) {
        return new HashSet<String>(ansibleTasks.get((Object)stage));
    }

    private static Set<String> collectSshKeys(SetupAction.SetupActionList setupActions) {
        HashSet<String> result = new HashSet<String>();
        if (setupActions != null) {
            for (SetupAction action : setupActions) {
                JsonPrimitive jsonSshKey;
                String sshKey;
                if (action.type != SetupAction.SetupActionType.ADD_AUTHORIZED_KEY || !StringUtils.isNotBlank((String)(sshKey = (jsonSshKey = action.params.getAsJsonPrimitive("sshKey")) == null ? "" : jsonSshKey.getAsString()))) continue;
                result.add(sshKey);
            }
        }
        return result;
    }

    private static Set<String> collectSystemPackages(SetupAction.SetupActionList setupActions) {
        HashSet<String> result = new HashSet<String>();
        if (setupActions != null) {
            for (SetupAction action : setupActions) {
                if (action.type != SetupAction.SetupActionType.INSTALL_SYSTEM_PACKAGES) continue;
                JsonArray jsonPackages = action.params.getAsJsonArray("packages");
                for (JsonElement jsonPackage : jsonPackages) {
                    String packageName = jsonPackage.getAsString();
                    if (!StringUtils.isNotBlank((String)packageName)) continue;
                    result.add(packageName);
                }
            }
        }
        return result;
    }

    private static Multimap<String, String> collectAnsibleTasks(SetupAction.SetupActionList setupActions) {
        HashMultimap result = HashMultimap.create();
        if (setupActions != null) {
            for (SetupAction action : setupActions) {
                if (action.type != SetupAction.SetupActionType.RUN_ANSIBLE_TASKS) continue;
                JsonPrimitive jsonStage = action.params.getAsJsonPrimitive("stage");
                JsonPrimitive jsonAnsibleTask = action.params.getAsJsonPrimitive("ansibleTasks");
                String stage = jsonStage == null ? "after_dss_startup" : jsonStage.getAsString();
                String content = jsonAnsibleTask == null ? "" : jsonAnsibleTask.getAsString();
                if (!StringUtils.isNotBlank((String)content)) continue;
                result.put((Object)stage, (Object)content);
            }
        }
        return result;
    }

    private static SetupAction.SetupActionList filterOtherActions(SetupAction.SetupActionList setupActions) {
        SetupAction.SetupActionList result = new SetupAction.SetupActionList();
        if (setupActions != null) {
            for (SetupAction action : setupActions) {
                if (action.type == SetupAction.SetupActionType.INSTALL_SYSTEM_PACKAGES || action.type == SetupAction.SetupActionType.ADD_AUTHORIZED_KEY || action.type == SetupAction.SetupActionType.RUN_ANSIBLE_TASKS) continue;
                result.add(action);
            }
        }
        return result;
    }

    private static String withDefaultInstanceSettingsTemplateLabel(AuthCtx authCtx, String label) {
        return StringUtils.isNotBlank((String)label) ? label : "Instance template created on " + DateTimeFormat.forPattern((String)"MMM dd yyyy").print((ReadableInstant)DateTime.now()) + " by " + authCtx.getIdentifier();
    }
}

