/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.instances;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.license.License;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.cloud.CloudInstanceService;
import com.dataiku.fm.cloud.DNSservice;
import com.dataiku.fm.cloud.LoadBalancerUtils;
import com.dataiku.fm.cloud.aws.AWSDNSService;
import com.dataiku.fm.cloud.azure.AzureDNSService;
import com.dataiku.fm.cloud.gcp.GCPDNSService;
import com.dataiku.fm.model.FMServerCodes;
import com.dataiku.fm.model.SetupAction;
import com.dataiku.fm.model.agent.ExpandedInstanceSettings;
import com.dataiku.fm.model.db.CertificateMode;
import com.dataiku.fm.model.db.InstanceSettingsTemplate;
import com.dataiku.fm.model.db.LoadBalancerNodeMapping;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.LogicalLoadBalancer;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.db.PhysicalInstanceCreationState;
import com.dataiku.fm.model.db.Sublicense;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.published.PublicLogicalInstance;
import com.dataiku.fm.model.published.PublicProtoLogicalInstance;
import com.dataiku.fm.model.published.SaveInstanceResult;
import com.dataiku.fm.model.settings.Cloud;
import com.dataiku.fm.model.settings.CloudStaticData;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.model.settings.InstanceImagesSettings;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.agentapi.AgentAPIController;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.CreationDataUtils;
import com.dataiku.fm.server.instances.InstanceAgentActionsQueueService;
import com.dataiku.fm.server.instances.InstanceSettingsTemplateCRUDService;
import com.dataiku.fm.server.instances.InstancesHelper;
import com.dataiku.fm.server.instances.JSonHelper;
import com.dataiku.fm.server.instances.NodesDirectoryUpdateService;
import com.dataiku.fm.server.instances.PhysicalInstanceProvisioningService;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InstancesCRUDService {
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private CloudCryptoService cryptoService;
    @Autowired
    private CloudInstanceService cloudInstanceService;
    @Autowired
    private InstanceAgentActionsQueueService instanceAgentActionsQueueService;
    @Autowired
    private NodesDirectoryUpdateService nodesDirectoryUpdateService;
    @Autowired
    private PhysicalInstanceProvisioningService reprovisionService;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    @Autowired
    private AWSDNSService awsdnsService;
    @Autowired
    private AzureDNSService azureDNSService;
    @Autowired
    private GCPDNSService gcpdnsService;
    private final Map<String, String> volatileAdminPasswords = new HashMap<String, String>();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.instances");

    public List<PublicLogicalInstance> list(String tenantId) {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        Map<String, String> dssImagesLabelById = InstancesCRUDService.buildDssImagesLabelById(FMApp.getFMSettingsUnsafe());
        ArrayList<PublicLogicalInstance> ret = new ArrayList<PublicLogicalInstance>();
        for (LogicalInstance li : this.dbService.listResults(LogicalInstance.class, "SELECT li from logicalinstance li where li.tenant=?1", tenant)) {
            ret.add(this.convertToDTO(tenantId, li, dssImagesLabelById));
        }
        return ret;
    }

    public List<LogicalInstance> listInternal(String tenantId) {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        ArrayList<LogicalInstance> ret = new ArrayList<LogicalInstance>();
        for (LogicalInstance li : this.dbService.listResults(LogicalInstance.class, "SELECT li from logicalinstance li where li.tenant=?1", tenant)) {
            ret.add(li);
        }
        return ret;
    }

    @Nullable
    public LogicalLoadBalancer getLoadBalancer(LogicalInstance instance) {
        return this.getLoadBalancer(instance.getId());
    }

    @Nullable
    public LogicalLoadBalancer getLoadBalancer(String instanceId) {
        LoadBalancerNodeMapping mapping = this.dbService.getSingleResult(LoadBalancerNodeMapping.class, "SELECT lbm from loadbalancernodemapping lbm where lbm.logicalInstance.id = ?1", instanceId);
        if (mapping == null) {
            return null;
        }
        return mapping.getLogicalLoadBalancer();
    }

    public LogicalInstance getInternal(String tenantId, String instanceId) {
        return this.getLogicalInstanceMand(tenantId, instanceId);
    }

    public PublicLogicalInstance get(String tenantId, String instanceId) {
        LogicalInstance li = this.getLogicalInstanceMand(tenantId, instanceId);
        Map<String, String> dssImagesLabelById = InstancesCRUDService.buildDssImagesLabelById(FMApp.getFMSettingsUnsafe());
        return this.convertToDTO(tenantId, li, dssImagesLabelById);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicLogicalInstance convertToDTO(String tenantId, LogicalInstance li, Map<String, String> dssImagesLabelById) {
        PublicLogicalInstance pli = new PublicLogicalInstance();
        VirtualNetwork vn = li.getVirtualNetwork();
        InstanceSettingsTemplate ist = li.getInstanceSettingsTemplate();
        LogicalLoadBalancer loadBalancer = this.getLoadBalancer(li);
        pli.id = li.getId();
        pli.virtualNetworkId = vn.getId();
        pli.dssNodeType = li.getDssNodeType();
        pli.externalURL = li.getExternalURL();
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        DNSservice dnsService = switch (settings.cloud) {
            case Cloud.AWS -> this.awsdnsService;
            case Cloud.AZURE -> this.azureDNSService;
            case Cloud.GCP -> this.gcpdnsService;
            default -> throw new IllegalStateException("Unknown cloud provider");
        };
        if (loadBalancer != null && loadBalancer.getCurrentPhysicalLoadBalancer() != null) {
            pli.loadBalancerId = loadBalancer.getId();
            pli.loadBalancerName = loadBalancer.getName();
            String protocol = loadBalancer.getCertificateMode() == CertificateMode.NO_CERTIFICATE ? "http" : "https";
            pli.linkViaLoadBalancer = loadBalancer.getLoadBalancerNodeMapping().stream().filter(m -> m.getLogicalInstance().getId().equals(li.getId())).map(m -> protocol + "://" + LoadBalancerUtils.getFQDN(m.getSubdomainOrFQDN(), loadBalancer, dnsService)).findAny().orElse(null);
        }
        pli.instanceSettingsTemplateId = ist.getId();
        pli.label = li.getLabel();
        pli.description = li.getDescription();
        pli.imageId = li.getImageId();
        pli.imageLabel = dssImagesLabelById.get(li.getImageId());
        pli.cloudInstanceType = li.getCloudInstanceType();
        pli.dataVolumeType = li.getDataVolumeType();
        pli.dataVolumeIOPS = li.getDataVolumeIOPS();
        pli.dataVolumeSizeGB = li.getDataVolumeSizeGB();
        pli.dataVolumeSizeMaxGB = li.getDataVolumeSizeMaxGB();
        pli.encryptDataVolume = li.getEncryptDataVolume();
        pli.dataVolumeEncryptionKey = li.getDataVolumeEncryptionKey();
        pli.encryptRootVolume = li.getEncryptRootVolume();
        pli.singleNodeAsInfrastructure = li.getSingleNodeAsInfrastructure() == null || li.getSingleNodeAsInfrastructure() != false;
        String fmTags = li.getFMTags();
        pli.fmTags = StringUtils.isNotBlank((String)fmTags) ? (List)JSON.parse((String)fmTags, (TypeToken)new TypeToken<List<String>>(){}) : Collections.emptyList();
        pli.cloudTags = CloudTagList.fromJSON(li.getCloudTags());
        pli.inheritedCloudTags = li.getInheritedCloudTags(loadBalancer);
        pli.licenseSelectionMode = li.getLicenseSelectionMode();
        if (li.getSublicense() != null) {
            pli.sublicenseId = li.getSublicense().getId();
        }
        pli.enableAutomatedSnapshot = li.getEnableAutomatedSnapshot();
        pli.automatedSnapshotPeriod = li.getAutomatedSnapshotPeriod();
        pli.automatedSnapshotRetention = li.getAutomatedSnapshotRetention();
        pli.awsAssignElasticIP = li.isAwsAssignElasticIP();
        pli.awsElasticIPAllocationId = li.getAwsElasticIPAllocationId();
        pli.awsPrivateIP = li.getAwsPrivateIP();
        pli.rootVolumeSizeGB = li.getRootVolumeSizeGB();
        pli.awsRootVolumeType = li.getAwsRootVolumeType();
        pli.awsRootVolumeIOPS = li.getAwsRootVolumeIOPS();
        pli.awsRegion = vn.getAwsRegion();
        pli.azureRGForSnapshots = li.getAzureRGForSnapshots();
        pli.azureAvailabilityZone = li.getAzureAvailabilityZone();
        pli.azureAssignElasticIP = li.isAzureAssignPublicIP();
        pli.azurePublicIPId = li.getAzurePublicIPId();
        pli.azurePrivateIP = li.getAzurePrivateIP();
        pli.azureInstanceName = li.getAzureInstanceName();
        pli.azurePublicIPName = li.getAzurePublicIPName();
        pli.azureDataVolumeName = li.getAzureDataVolumeName();
        pli.azureOSVolumeName = li.getAzureOSVolumeName();
        pli.azureNicName = li.getAzureNicName();
        pli.azureRegion = vn.getAzureRegion();
        pli.gcpAssignPublicIP = li.isGcpAssignPublicIP();
        pli.gcpPublicIPId = li.getGcpPublicIPId();
        pli.gcpZone = li.getGcpZone();
        pli.gcpPrivateIP = li.getGcpPrivateIP();
        pli.gcpInstanceName = li.getGcpInstanceName();
        pli.gcpDataVolumeName = li.getGcpDataVolumeName();
        pli.additionalDomainNamesForCertificate = li.getAdditionalDomainNamesForCertificate() != null ? (List<Object>)JSON.parse((String)li.getAdditionalDomainNamesForCertificate(), JSON.StringList.class) : Collections.emptyList();
        pli.sslCertificatePEM = li.getSslCertificatePEM();
        pli.sslCertificateKeyPEM = StringUtils.isNotBlank((String)li.getSslCertificateKeyPEM()) ? "************" : "";
        pli.sslCertificateKeyStorageMode = li.getSslCertificateKeyStorageMode();
        pli.sslCertificateAwsSecretName = li.getSslCertificateAwsSecretName();
        pli.sslCertificateGcpSecretId = li.getSslCertificateGcpSecretId();
        pli.azureSSLCertificateSecretName = li.getAzureSSLCertificateSecretName();
        pli.azureSSLCertificateSecretVersion = li.getAzureSSLCertificateSecretVersion();
        pli.azureKeyvaultUrl = li.getAzureKeyvaultUrl();
        pli.azureSSLCertificateName = li.getAzureSSLCertificateName();
        pli.azureSSLCertificateVersion = li.getAzureSSLCertificateVersion();
        pli.azureSSLCertificateContentType = li.getAzureSSLCertificateContentType();
        String key = tenantId + "__" + li.getId();
        Map<String, String> map = this.volatileAdminPasswords;
        synchronized (map) {
            if (this.volatileAdminPasswords.containsKey(key)) {
                pli.hasInitialAdminPassword = true;
            }
        }
        pli.virtualNetworkLabel = StringUtils.isBlank((String)vn.getLabel()) ? vn.getId() : vn.getLabel();
        pli.resourceGroupForCreatedResources = StringUtils.isBlank((String)vn.getAzureRgNameForCreatedResources()) ? vn.getAzureRgName() : vn.getAzureRgNameForCreatedResources();
        pli.instanceSettingsTemplateLabel = StringUtils.isBlank((String)ist.getLabel()) ? ist.getId() : ist.getLabel();
        return pli;
    }

    public InitialPassword getInitialAdminPassword(String tenantId, String instanceId) {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        LogicalInstance li = this.dbService.getSingleResult(LogicalInstance.class, "SELECT li from logicalinstance li where li.tenant=?1 AND li.id=?2", tenant, instanceId);
        if (li == null) {
            throw new RuntimeException("Instance not found");
        }
        String key = tenantId + "__" + li.getId();
        Map<String, String> map = this.volatileAdminPasswords;
        synchronized (map) {
            if (this.volatileAdminPasswords.containsKey(key)) {
                InitialPassword ret = new InitialPassword();
                ret.password = this.volatileAdminPasswords.get(key);
                this.volatileAdminPasswords.remove(key);
                return ret;
            }
            throw new IllegalStateException("Initial password is no longer available. It has already been retrieved or FM server has been recently restarted.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInitialAdminPassword(String tenantId, String instanceId) {
        Map<String, String> map = this.volatileAdminPasswords;
        synchronized (map) {
            String key = tenantId + "__" + instanceId;
            this.volatileAdminPasswords.remove(key);
        }
    }

    public PublicLogicalInstance create(String tenantId, PublicProtoLogicalInstance protoInstance) throws CodedException {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        this.checkLabelUnicityAcrossVirtualNetwork(tenantId, protoInstance.virtualNetworkId, protoInstance.label);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
            assert (tenant != null);
            VirtualNetwork vn = (VirtualNetwork)this.dbService.getThreadEM().find(VirtualNetwork.class, (Object)protoInstance.virtualNetworkId);
            if (vn == null) {
                throw new IllegalArgumentException("Invalid network id");
            }
            tenant = vn.getTenant();
            InstanceSettingsTemplate ist = (InstanceSettingsTemplate)this.dbService.getThreadEM().find(InstanceSettingsTemplate.class, (Object)protoInstance.instanceSettingsTemplateId);
            if (ist == null) {
                throw new IllegalArgumentException("Invalid instance settings template id");
            }
            this.cloudInstanceService.checkInstanceCreation(vn, ist);
            LogicalInstance li = new LogicalInstance();
            li.setId("li-" + SecretKeyGenerator.generate((int)12));
            li.setTenant(tenant);
            li.setVirtualNetwork(vn);
            li.setInstanceSettingsTemplate(ist);
            if (this.cryptoService.isAbleToEncrypt(li.getTenant())) {
                li.setAgentSecret(this.cryptoService.encrypt(li.getTenant(), SecretKeyGenerator.generate((int)16)));
            } else {
                li.setAgentSecret(SecretKeyGenerator.generate((int)16));
            }
            li.setLabel(protoInstance.label);
            li.setDescription(protoInstance.description);
            li.setDssNodeType(protoInstance.dssNodeType);
            li.setExternalURL(protoInstance.externalURL);
            li.setImageId(protoInstance.imageId);
            li.setSingleNodeAsInfrastructure(protoInstance.singleNodeAsInfrastructure);
            CreationDataUtils.InstanceCreationData icd = CreationDataUtils.getInstanceCreationData(tenantId);
            li.setAzureInstanceName(protoInstance.azureInstanceName);
            li.setAzureAvailabilityZone(protoInstance.azureAvailabilityZone);
            li.setAzurePublicIPId(protoInstance.azurePublicIPId);
            li.setAzureDataVolumeName(protoInstance.azureDataVolumeName);
            li.setAzureOSVolumeName(protoInstance.azureOSVolumeName);
            li.setAzureNicName(protoInstance.azureNicName);
            li.setAzurePublicIPName(protoInstance.azurePublicIPName);
            li.setGcpInstanceName(protoInstance.gcpInstanceName);
            li.setGcpDataVolumeName(protoInstance.gcpDataVolumeName);
            if (protoInstance.additionalDomainNamesForCertificate != null && !protoInstance.additionalDomainNamesForCertificate.isEmpty()) {
                li.setAdditionalDomainNamesForCertificate(this.arrayToStringCleaned(protoInstance.additionalDomainNamesForCertificate));
            }
            li.setCloudInstanceType(protoInstance.cloudInstanceType == null ? icd.defaultCloudInstanceType : protoInstance.cloudInstanceType);
            li.setDataVolumeType(protoInstance.dataVolumeType == null ? icd.defaultDataVolumeType : protoInstance.dataVolumeType);
            li.setDataVolumeSizeGB(protoInstance.dataVolumeSizeGB == null ? icd.defaultDataVolumeSizeGB : protoInstance.dataVolumeSizeGB);
            li.setDataVolumeSizeMaxGB(protoInstance.dataVolumeSizeMaxGB == null ? icd.defaultDataVolumeSizeMaxGB : protoInstance.dataVolumeSizeMaxGB);
            li.setDataVolumeIOPS(protoInstance.dataVolumeIOPS == null ? icd.defaultDataVolumeIOPS : protoInstance.dataVolumeIOPS);
            this.setVolumeEncryption(protoInstance, settings, li);
            li.setCloudTags(CloudTagList.toJSON(protoInstance.cloudTags));
            li.setFMTags(JSON.json(protoInstance.fmTags));
            li.setRootVolumeSizeGB(protoInstance.rootVolumeSizeGB == null ? icd.defaultRootVolumeSizeGB : protoInstance.rootVolumeSizeGB);
            li.setAwsRootVolumeType(protoInstance.awsRootVolumeType);
            li.setAwsRootVolumeIOPS(protoInstance.awsRootVolumeIOPS);
            li.setEnableAutomatedSnapshot(Optional.ofNullable(protoInstance.enableAutomatedSnapshot).orElse(icd.defaultEnableAutomatedSnapshot));
            li.setAutomatedSnapshotPeriod(Optional.ofNullable(protoInstance.automatedSnapshotPeriod).orElse(icd.defaultAutomatedSnapshotPeriod));
            li.setAutomatedSnapshotRetention(Optional.ofNullable(protoInstance.automatedSnapshotRetention).orElse(icd.defaultAutomatedSnapshotRetention));
            logger.infoV("Logical instance created: %s", new Object[]{li.getId()});
            boolean awsInstanceCreateFromExternalSnapshotEnabled = DKUApp.getParams().getBoolParam("dku.fm.feature.awsinstancecreatefromexternalsnapshot.enabled", false);
            boolean azureInstanceCreateFromExternalSnapshotEnabled = FeatureFlags.isEnabled((String)"fm.azure.instancecreatefromexternalsnapshot");
            if (awsInstanceCreateFromExternalSnapshotEnabled && StringUtils.isNotBlank((String)protoInstance.awsSnapshotId)) {
                pdv = this.cloudInstanceService.createInitialPhysicalDataVolumeFromExternalSnapshot(rwt, li, protoInstance.awsSnapshotId);
                logger.infoV("Physical data volume created: %s, based on snapshot: %s", new Object[]{pdv.getId(), protoInstance.awsSnapshotId});
            } else if (azureInstanceCreateFromExternalSnapshotEnabled && StringUtils.isNotBlank((String)protoInstance.azureSnapshotId)) {
                pdv = this.cloudInstanceService.createInitialPhysicalDataVolumeFromExternalSnapshot(rwt, li, protoInstance.azureSnapshotId);
                logger.infoV("Physical data volume created: %s, based on snapshot: %s", new Object[]{pdv.getId(), protoInstance.azureSnapshotId});
            } else {
                pdv = this.cloudInstanceService.createInitialPhysicalDataVolume(rwt, li);
                logger.infoV("Physical data volume created: %s", new Object[]{pdv.getId()});
            }
            this.dbService.getThreadEM().persist((Object)li);
            rwt.commit();
            PublicLogicalInstance publicLogicalInstance = this.convertToDTO(tenantId, li, InstancesCRUDService.buildDssImagesLabelById(settings));
            return publicLogicalInstance;
        }
    }

    private void setVolumeEncryption(PublicProtoLogicalInstance protoInstance, FMSettings settings, LogicalInstance li) {
        if (protoInstance.volumesEncryption == null) {
            protoInstance.volumesEncryption = PublicProtoLogicalInstance.VolumeEncryptionMode.NONE;
        }
        block0 : switch (settings.cloud) {
            case AWS: {
                switch (protoInstance.volumesEncryption) {
                    case DEFAULT_KEY: {
                        li.setEncryptDataVolume(true);
                        li.setEncryptRootVolume(true);
                        break;
                    }
                    case TENANT: {
                        li.setEncryptDataVolume(true);
                        li.setEncryptRootVolume(true);
                        li.setDataVolumeEncryptionKey(li.getTenant().getAwsCMKId());
                        break;
                    }
                    case CUSTOM: {
                        li.setEncryptDataVolume(true);
                        li.setEncryptRootVolume(true);
                        li.setDataVolumeEncryptionKey(protoInstance.volumesEncryptionKey);
                        break;
                    }
                    case NONE: {
                        li.setEncryptDataVolume(false);
                        li.setEncryptRootVolume(false);
                    }
                }
                break;
            }
            case AZURE: {
                switch (protoInstance.volumesEncryption) {
                    case DEFAULT_KEY: {
                        li.setEncryptDataVolume(true);
                        li.setEncryptRootVolume(true);
                        break block0;
                    }
                    case CUSTOM: {
                        li.setEncryptDataVolume(true);
                        li.setEncryptRootVolume(true);
                        li.setDataVolumeEncryptionKey(protoInstance.volumesEncryptionKey);
                        break block0;
                    }
                    case TENANT: 
                    case NONE: {
                        throw new UnsupportedOperationException("Cannot encrypt with TENANT or NONE on Azure");
                    }
                }
                break;
            }
            case GCP: {
                switch (protoInstance.volumesEncryption) {
                    case DEFAULT_KEY: {
                        li.setEncryptDataVolume(true);
                        li.setEncryptRootVolume(true);
                        break block0;
                    }
                    case TENANT: {
                        li.setEncryptDataVolume(true);
                        li.setEncryptRootVolume(true);
                        String tenantProjectId = StringUtils.defaultIfBlank((String)li.getTenant().getVirtualCloudAccount(FMApp.getFMSettingsUnsafe()).getGcpProjectId(), (String)settings.gcpSettings.projectId);
                        String cryptoKeyVersionSuffix = StringUtils.isBlank((String)li.getTenant().getGcpCryptoKeyVersion()) ? "" : "/cryptoKeyVersions/" + li.getTenant().getGcpCryptoKeyVersion();
                        li.setDataVolumeEncryptionKey(String.format("projects/%s/locations/%s/keyRings/%s/cryptoKeys/%s%s", tenantProjectId, li.getTenant().getGcpLocationId(), li.getTenant().getGcpKeyRing(), li.getTenant().getGcpCryptoKey(), cryptoKeyVersionSuffix));
                        break block0;
                    }
                    case CUSTOM: {
                        li.setEncryptDataVolume(true);
                        li.setEncryptRootVolume(true);
                        li.setDataVolumeEncryptionKey(protoInstance.volumesEncryptionKey);
                        break block0;
                    }
                    case NONE: {
                        li.setEncryptDataVolume(false);
                        li.setEncryptRootVolume(false);
                    }
                }
            }
        }
    }

    public SaveInstanceResult update(String tenantId, PublicLogicalInstance pli) throws CodedException {
        String encryptedSslCertificateKeyPEM;
        LogicalInstance li = this.getLogicalInstanceMand(tenantId, pli.id);
        this.checkLabelUnicityAcrossVirtualNetwork(tenantId, pli.virtualNetworkId, pli.label, pli.id);
        InstanceSettingsTemplate ist = this.dbService.getSingleResult(InstanceSettingsTemplate.class, "SELECT ist from instancesettingstemplate ist where ist.id = ?1", pli.instanceSettingsTemplateId);
        if (ist == null) {
            throw new Error("unknown InstanceSettingsTemplate");
        }
        SaveInstanceResult ret = new SaveInstanceResult();
        ret.needsReprovision = this.requireReprovision(li, pli);
        ret.success = true;
        li.setLabel(pli.label);
        li.setDescription(pli.description);
        li.setImageId(pli.imageId);
        li.setDssNodeType(pli.dssNodeType);
        li.setExternalURL(pli.externalURL);
        li.setCloudInstanceType(pli.cloudInstanceType);
        li.setDataVolumeSizeGB(pli.dataVolumeSizeGB);
        li.setDataVolumeSizeMaxGB(pli.dataVolumeSizeMaxGB);
        li.setDataVolumeType(pli.dataVolumeType);
        li.setDataVolumeIOPS(pli.dataVolumeIOPS);
        li.setEncryptDataVolume(pli.encryptDataVolume);
        li.setDataVolumeEncryptionKey(pli.dataVolumeEncryptionKey);
        li.setEncryptRootVolume(pli.encryptRootVolume);
        li.setSingleNodeAsInfrastructure(pli.singleNodeAsInfrastructure);
        li.setInstanceSettingsTemplate(ist);
        li.setFMTags(JSON.json(pli.fmTags));
        li.setCloudTags(CloudTagList.toJSON(pli.cloudTags));
        li.setLicenseSelectionMode(pli.licenseSelectionMode);
        if (pli.sublicenseId != null) {
            Sublicense sl = this.dbService.getSingleResult(Sublicense.class, "SELECT sl from sublicense sl where sl.id = ?1 and sl.tenant = ?2", pli.sublicenseId, li.getTenant());
            if (sl == null) {
                throw new Error("unknown Sublicense");
            }
            li.setSublicense(sl);
        }
        li.setEnableAutomatedSnapshot(pli.enableAutomatedSnapshot);
        li.setAutomatedSnapshotPeriod(pli.automatedSnapshotPeriod);
        li.setAutomatedSnapshotRetention(pli.automatedSnapshotRetention);
        li.setAwsAssignElasticIP(pli.awsAssignElasticIP);
        li.setAwsElasticIPAllocationId(pli.awsElasticIPAllocationId);
        li.setAwsPrivateIP(pli.awsPrivateIP);
        li.setRootVolumeSizeGB(pli.rootVolumeSizeGB);
        li.setAwsRootVolumeType(pli.awsRootVolumeType);
        li.setAwsRootVolumeIOPS(pli.awsRootVolumeIOPS);
        li.setAzureAssignPublicIP(pli.azureAssignElasticIP);
        li.setAzurePublicIPId(pli.azurePublicIPId);
        li.setAzurePrivateIP(pli.azurePrivateIP);
        li.setAzureInstanceName(pli.azureInstanceName);
        li.setAzurePublicIPName(pli.azurePublicIPName);
        li.setAzureDataVolumeName(pli.azureDataVolumeName);
        li.setAzureOSVolumeName(pli.azureOSVolumeName);
        li.setAzureNicName(pli.azureNicName);
        li.setAzureRGForSnapshots(StringUtils.stripToNull((String)pli.azureRGForSnapshots));
        li.setGcpAssignPublicIP(pli.gcpAssignPublicIP);
        li.setGcpPublicIPId(pli.gcpPublicIPId);
        li.setGcpZone(pli.gcpZone);
        li.setGcpPrivateIP(pli.gcpPrivateIP);
        li.setGcpInstanceName(pli.gcpInstanceName);
        li.setGcpDataVolumeName(pli.gcpDataVolumeName);
        li.setAdditionalDomainNamesForCertificate(this.arrayToStringCleaned(pli.additionalDomainNamesForCertificate));
        li.setSslCertificatePEM(pli.sslCertificatePEM);
        li.setSslCertificateAwsSecretName(pli.sslCertificateAwsSecretName);
        li.setSslCertificateGcpSecretId(pli.sslCertificateGcpSecretId);
        li.setSslCertificateKeyStorageMode(pli.sslCertificateKeyStorageMode);
        li.setAzureSSLCertificateSecretName(pli.azureSSLCertificateSecretName);
        li.setAzureSSLCertificateSecretVersion(pli.azureSSLCertificateSecretVersion);
        li.setAzureKeyvaultUrl(pli.azureKeyvaultUrl);
        li.setAzureSSLCertificateName(pli.azureSSLCertificateName);
        li.setAzureSSLCertificateVersion(pli.azureSSLCertificateVersion);
        li.setAzureSSLCertificateContentType(pli.azureSSLCertificateContentType);
        if (StringUtils.isNotBlank((String)pli.sslCertificateKeyPEM) && pli.sslCertificateKeyPEM.replaceAll("\\*", "").length() > 0 && (encryptedSslCertificateKeyPEM = this.encryptSslCertificateKeyPEM(pli.sslCertificateKeyPEM, pli.sslCertificateKeyStorageMode, li.getTenant())) != null) {
            li.setSslCertificateKeyPEM(encryptedSslCertificateKeyPEM);
        }
        this.dbService.getThreadEM().persist((Object)li);
        return ret;
    }

    public boolean updateEncryption(LogicalInstance li, Tenant current, Tenant updated) {
        String key = li.getSslCertificateKeyPEM();
        if (StringUtils.isNotEmpty((String)key)) {
            String plainKey;
            String string = plainKey = this.cryptoService.isAbleToEncrypt(current) ? this.cryptoService.decrypt(current, key) : key;
            if (this.cryptoService.isAbleToEncrypt(updated)) {
                li.setSslCertificateKeyPEM(this.cryptoService.encrypt(updated, plainKey));
            } else {
                li.setSslCertificateKeyPEM(plainKey);
            }
            return true;
        }
        return false;
    }

    private boolean requireReprovision(LogicalInstance li, PublicLogicalInstance pli) {
        return li.getCurrentPhysicalInstance() != null && (!Objects.equals(li.getImageId(), pli.imageId) || !Objects.equals(li.getCloudInstanceType(), pli.cloudInstanceType) || !Objects.equals(li.getInstanceSettingsTemplate().getId(), pli.instanceSettingsTemplateId) || !Objects.equals(li.isAwsAssignElasticIP(), pli.awsAssignElasticIP) || !Objects.equals(li.getAwsElasticIPAllocationId(), pli.awsElasticIPAllocationId) || !Objects.equals(li.getAwsPrivateIP(), pli.awsPrivateIP) || !Objects.equals(li.isAzureAssignPublicIP(), pli.azureAssignElasticIP) || !Objects.equals(li.getAzurePublicIPId(), pli.azurePublicIPId) || !Objects.equals(li.getAzurePublicIPName(), pli.azurePublicIPName) || !Objects.equals(li.getAzureNicName(), pli.azureNicName) || !Objects.equals(li.getAzureOSVolumeName(), pli.azureOSVolumeName) || !Objects.equals(li.getAzureInstanceName(), pli.azureInstanceName) || !Objects.equals(li.isGcpAssignPublicIP(), pli.gcpAssignPublicIP) || !Objects.equals(li.getGcpPublicIPId(), pli.gcpPublicIPId) || !Objects.equals(li.getGcpZone(), pli.gcpZone) || !Objects.equals(li.getGcpPrivateIP(), pli.gcpPrivateIP) || !Objects.equals(li.getAzurePrivateIP(), pli.azurePrivateIP) || !Objects.equals(Optional.ofNullable(li.getAdditionalDomainNamesForCertificate()).orElse("[]"), JSON.json(pli.additionalDomainNamesForCertificate)) || !Objects.equals(li.getSslCertificatePEM(), pli.sslCertificatePEM) || !Objects.equals(li.getSslCertificateAwsSecretName(), pli.sslCertificateAwsSecretName) || !Objects.equals(li.getSslCertificateGcpSecretId(), pli.sslCertificateGcpSecretId) || !Objects.equals((Object)li.getSslCertificateKeyStorageMode(), (Object)pli.sslCertificateKeyStorageMode) || !Objects.equals(li.getAzureSSLCertificateSecretName(), pli.azureSSLCertificateSecretName) || !Objects.equals(li.getAzureSSLCertificateSecretVersion(), pli.azureSSLCertificateSecretVersion) || !Objects.equals(li.getAzureKeyvaultUrl(), pli.azureKeyvaultUrl) || !Objects.equals(li.getAzureSSLCertificateName(), pli.azureSSLCertificateName) || !Objects.equals(li.getAzureSSLCertificateVersion(), pli.azureSSLCertificateVersion) || !Objects.equals((Object)li.getAzureSSLCertificateContentType(), (Object)pli.azureSSLCertificateContentType) || !Objects.equals(li.getSslCertificatePEM(), this.encryptSslCertificateKeyPEM(pli.sslCertificateKeyPEM, pli.sslCertificateKeyStorageMode, li.getTenant())) || !Objects.equals(li.getDataVolumeSizeGB(), pli.dataVolumeSizeGB) || !Objects.equals(CloudTagList.fromJSON(li.getCloudTags()), pli.cloudTags));
    }

    private String encryptSslCertificateKeyPEM(String sslCertificateKeyPEM, LogicalInstance.CustomCertificateKeyStorageMode sslCertificateKeyStorageMode, Tenant tenant) {
        String pliSslCertificateKeyPEM;
        if (StringUtils.isNotBlank((String)sslCertificateKeyPEM) && sslCertificateKeyStorageMode == LogicalInstance.CustomCertificateKeyStorageMode.INLINE_ENCRYPTED) {
            logger.info((Object)"Encrypting the key");
            pliSslCertificateKeyPEM = this.cryptoService.encrypt(tenant, sslCertificateKeyPEM);
        } else {
            pliSslCertificateKeyPEM = null;
        }
        return pliSslCertificateKeyPEM;
    }

    public ExpandedInstanceSettings getExpandedInstanceSettings(String tenantId, String instanceId) {
        ExpandedInstanceSettings ret = new ExpandedInstanceSettings();
        LogicalInstance li = this.getLogicalInstanceMand(tenantId, instanceId);
        if (li.getInstanceSettingsTemplate() != null) {
            InstanceSettingsTemplate instanceSettingsTemplate = li.getInstanceSettingsTemplate();
            ret.setupActions = InstancesCRUDService.filterEnabledActions(JSonHelper.parseJsonSetupActions(instanceSettingsTemplate.getSetupActions()));
            ret.setupActions.addAll(0, InstanceSettingsTemplateCRUDService.getHiddenSetupActions(li.getDssNodeType()));
            if (ret.setupActions.stream().noneMatch(t -> t.type.equals((Object)SetupAction.SetupActionType.SETUP_K8S_AND_SPARK))) {
                ret.setupActions.add(new SetupAction(SetupAction.SetupActionType.SETUP_NONE_K8S_AND_SPARK));
            }
        }
        return ret;
    }

    private static SetupAction.SetupActionList filterEnabledActions(SetupAction.SetupActionList setupActionList) {
        return setupActionList.stream().filter(action -> action.enabled).collect(SetupAction.SetupActionList::new, ArrayList::add, ArrayList::addAll);
    }

    public String getSSLCertificateKey(String tenantId, String instanceId) {
        LogicalInstance li = this.getLogicalInstanceMand(tenantId, instanceId);
        if (li.getSslCertificateKeyStorageMode() != LogicalInstance.CustomCertificateKeyStorageMode.INLINE_ENCRYPTED) {
            throw new IllegalArgumentException("There is no certificate key to retrieve, storage mode is not FM encryption.");
        }
        Tenant tenant = this.dbService.getSingleResult(Tenant.class, "SELECT tn from tenant tn where tn.id=?1", tenantId);
        return this.cryptoService.decrypt(tenant, li.getSslCertificateKeyPEM());
    }

    public InstanceLicense getLicense(String tenantId, String instanceId) {
        Sublicense sl;
        logger.info((Object)("getting license for " + tenantId + "." + instanceId));
        LogicalInstance li = this.getLogicalInstanceMand(tenantId, instanceId);
        InstanceLicense ret = new InstanceLicense();
        if (StringUtils.isNotBlank((String)li.getInstanceSettingsTemplate().getLicense())) {
            ret.license = li.getInstanceSettingsTemplate().getLicense();
        } else if (li.getTenant().getLicenseMode() != Tenant.LicenseMode.NONE && StringUtils.isNotBlank((String)li.getTenant().getLicense())) {
            ret.license = li.getTenant().getLicense();
        }
        boolean bl = ret.hasLicense = !StringUtils.isBlank((String)ret.license);
        if (ret.hasLicense && li.getLicenseSelectionMode() == LogicalInstance.InstanceLicenseSelectionMode.EXPLICIT_SUBLICENSE && (sl = li.getSublicense()) != null && sl.getSublicense() != null) {
            ret.usesSublicense = true;
            ret.sublicenseId = sl.getId();
            ret.sublicenseLabel = sl.getLabel();
            License licenseObj = (License)JSON.parse((String)ret.license, License.class);
            licenseObj.sublicense = (JsonObject)JSON.parse((String)sl.getSublicense(), JsonObject.class);
            ret.license = JSON.pretty((Object)licenseObj);
            logger.info((Object)("Applied sublicense " + JSON.json((Object)licenseObj.sublicense)));
        }
        return ret;
    }

    public PhysicalInstanceCreationState createStateSnapshot(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li) {
        PhysicalInstanceCreationState pics = new PhysicalInstanceCreationState();
        pics.setCloudInstanceType(li.getCloudInstanceType());
        pics.setImageId(li.getImageId());
        InstanceSettingsTemplate ist = li.getInstanceSettingsTemplate();
        if (ist != null) {
            InstanceSettingsTemplate istSnapshot = ist.copyWithoutId();
            istSnapshot.setId("ist-snap-" + SecretKeyGenerator.generate((int)12));
            istSnapshot.setLabel(String.format("Snapshot of %s at %s", ist.getLabel(), DKUDateUtils.isoFormatLocalNow()));
            istSnapshot.setCopiedFromId(ist.getId());
            istSnapshot.setForSnapshot(true);
            rwt.getThreadEM().persist((Object)istSnapshot);
            pics.setInstanceSettingsTemplate(istSnapshot);
        }
        return pics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInstanceSecrets(String tenantId, String instanceId, AgentAPIController.InstanceSecrets secrets) {
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            LogicalInstance li = this.getLogicalInstanceMand(tenantId, instanceId);
            if (secrets.adminAPIKey != null) {
                if (this.cryptoService.isAbleToEncrypt(li.getTenant())) {
                    li.setAdminAPIKey(this.cryptoService.encrypt(li.getTenant(), secrets.adminAPIKey));
                } else {
                    li.setAdminAPIKey(secrets.adminAPIKey);
                }
                rwt.getThreadEM().persist((Object)li);
                rwt.commit();
            }
        }
        if (secrets.adminPassword != null) {
            String key = tenantId + "__" + instanceId;
            Map<String, String> map = this.volatileAdminPasswords;
            synchronized (map) {
                this.volatileAdminPasswords.put(key, secrets.adminPassword);
            }
        }
    }

    public void onHeartbeatReceived(String tenantId, String instanceId, AgentAPIController.HeartbeatState hs) {
        PhysicalInstance pi = this.getPhysicalInstanceMand(tenantId, instanceId);
        logger.infoV("Updating instance heartbeat=%s liId=%s (%s)", new Object[]{tenantId, instanceId, JSON.json((Object)hs)});
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            pi.setLastHeartbeatTimestamp(System.currentTimeMillis());
            pi.setLastHeartbeatState(JSON.json((Object)hs));
            rwt.getThreadEM().persist((Object)pi);
            rwt.commit();
        }
        LogicalInstance li = pi.getLogicalInstance();
        double diskUsageRatio = (double)hs.bytesUsed / (double)(0x40000000L * (long)li.getDataVolumeSizeGB());
        logger.infoV("Computed disk usage ratio tenantId=%s liId=%s size=%d sizeMax=%d ratio=%f", new Object[]{tenantId, instanceId, li.getDataVolumeSizeGB(), li.getDataVolumeSizeMaxGB(), diskUsageRatio});
        CloudStaticData csd = FMApp.getCloudStaticData(FMApp.getFMSettingsUnsafe().cloud);
        if (csd.dataVolumeSettings.defaultOverCapacityRatio <= diskUsageRatio && li.getDataVolumeSizeGB() < li.getDataVolumeSizeMaxGB()) {
            logger.infoV("Disk instance usage is over %f, try to grow disk", new Object[]{diskUsageRatio});
            if (this.cloudInstanceService.growPhysicalDataVolume(li, csd.dataVolumeSettings.defaultGrowthFactor)) {
                InstanceAgentActionsQueueService.AgentCommand ac = new InstanceAgentActionsQueueService.AgentCommand();
                ac.commandId = "ac-" + SecretKeyGenerator.generate((int)8);
                ac.type = InstanceAgentActionsQueueService.AgentCommandType.GROW_FILESYSTEM;
                this.instanceAgentActionsQueueService.enqueueCommand(null, tenantId, instanceId, ac);
            }
        }
    }

    public FutureResponse<JsonObject> fetchAgentLogs(FMAuthCtx authCtx, String instanceId) throws Exception {
        PhysicalInstance pi = this.getPhysicalInstanceMand(authCtx.getTenantId(), instanceId);
        PhysicalInstance.LifecycleStage lifecycleStage = pi.getLifecycleStage();
        if (lifecycleStage != PhysicalInstance.LifecycleStage.RUNNING && lifecycleStage != PhysicalInstance.LifecycleStage.NOT_RESPONDING && lifecycleStage != PhysicalInstance.LifecycleStage.FAILED) {
            throw new IllegalStateException("Agent on this instance is not ready and cannot send its logs");
        }
        InstanceAgentActionsQueueService.AgentCommand ac = new InstanceAgentActionsQueueService.AgentCommand();
        ac.commandId = "ac-" + SecretKeyGenerator.generate((int)8);
        ac.type = InstanceAgentActionsQueueService.AgentCommandType.SEND_LOGS;
        return this.instanceAgentActionsQueueService.enqueueAndStartWait(authCtx, instanceId, ac);
    }

    public File getAgentLogFile(String tenantId, String instanceId) {
        PhysicalInstance pi = this.getPhysicalInstanceMand(tenantId, instanceId);
        logger.infoV("Read agent logs tenantId=%s liId=%s phId=%s", new Object[]{tenantId, instanceId, pi.getId()});
        File agentLogFilesDirectory = this.getAgentLogDirectory(tenantId, instanceId, pi.getId());
        if (!agentLogFilesDirectory.exists() || !agentLogFilesDirectory.isDirectory()) {
            logger.infoV("No logs found for tenantId=%s liId=%s phId=%s", new Object[]{tenantId, instanceId, pi.getId()});
            return null;
        }
        return DKUFileUtils.newestByNameFile((File)agentLogFilesDirectory, (String)"^agent_logs_.*\\.log$");
    }

    public void saveAgentLogs(String tenantId, String instanceId, InputStream inputStream) throws IOException {
        PhysicalInstance pi = this.getPhysicalInstanceMand(tenantId, instanceId);
        logger.infoV("Save agent logs tenantId=%s liId=%s phId=%s", new Object[]{tenantId, instanceId, pi.getId()});
        String agentFilename = "agent_logs_" + System.currentTimeMillis() + ".log";
        File agentLogDirectory = this.getAgentLogDirectory(tenantId, instanceId, pi.getId());
        File agentLogFile = new File(agentLogDirectory, agentFilename);
        DKUFileUtils.mkdirs((File)agentLogFile.getParentFile());
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)agentLogFile);
        if (!DKUApp.getParams().getBoolParam("dku.agent.logs.purge.enabled", true)) {
            logger.info((Object)"Agent logs purge disabled by configuration, skipping");
            return;
        }
        long purgeThreshold = DKUApp.getParams().getLongParam("dku.agent.logs.purge.maxSize", 0xC800000L);
        DKUFileUtils.compressAndKeepLastFilesUpToSize((File)agentLogDirectory, (String)"agent_logs_", (String)".log", (long)purgeThreshold, (String)agentFilename);
    }

    private File getAgentLogDirectory(String tenantId, String instanceId, String physicalInstanceId) {
        return FMApp.getFile((String[])new String[]{"tmp", "agent-logs", instanceId, physicalInstanceId});
    }

    public AWSKeypair getDataikuAwsKeypair(String tenantId, String instanceId) {
        LogicalInstance li = this.getLogicalInstanceMand(tenantId, instanceId);
        assert (li.getInstanceSettingsTemplate().getDataikuAwsKeypairStorageMode() == InstanceSettingsTemplate.DataikuAWSKeypairStorageMode.INLINE_ENCRYPTED);
        Tenant tenant = this.dbService.getSingleResult(Tenant.class, "SELECT tn from tenant tn where tn.id=?1", tenantId);
        AWSKeypair ret = new AWSKeypair();
        ret.awsAccessKeyId = li.getInstanceSettingsTemplate().getDataikuAwsAccessKeyId();
        ret.awsSecretAccessKey = this.cryptoService.decrypt(tenant, li.getInstanceSettingsTemplate().getDataikuAwsSecretAccessKey());
        return ret;
    }

    public NodesDirectory getNodesDirectory(String tenantId, String instanceId) {
        LogicalInstance li = this.getLogicalInstanceMand(tenantId, instanceId);
        return this.nodesDirectoryUpdateService.getCurrentNodesDirectory(tenantId, li.getVirtualNetwork().getId());
    }

    public AdminAPIKey getAdminAPIKey(String tenantId, String instanceId) {
        LogicalInstance li = InstancesHelper.getInstance(this.dbService, tenantId, instanceId);
        AdminAPIKey ret = new AdminAPIKey();
        ret.adminAPIKey = this.cryptoService.decrypt(li.getTenant(), li.getAdminAPIKey());
        return ret;
    }

    private static Map<String, String> buildDssImagesLabelById(FMSettings settings) {
        HashMap<String, String> dssImagesLabelById = new HashMap<String, String>();
        for (InstanceImagesSettings.InstanceImage ii : FMApp.getInstanceImagesSettings((Cloud)settings.cloud).images) {
            dssImagesLabelById.put(ii.id, ii.label);
        }
        return dssImagesLabelById;
    }

    private PhysicalInstance getPhysicalInstanceMand(String tenantId, String instanceId) {
        PhysicalInstance pi = this.getPhysicalInstance(tenantId, instanceId);
        if (pi == null) {
            throw new IllegalStateException(String.format("No physical instance attached to instance %s.%s", tenantId, instanceId));
        }
        return pi;
    }

    public PhysicalInstance getPhysicalInstance(String tenantId, String instanceId) {
        LogicalInstance li = this.getLogicalInstanceMand(tenantId, instanceId);
        return this.dbService.getSingleResult(PhysicalInstance.class, "SELECT pi from physicalinstance pi where pi.logicalInstance=?1", li);
    }

    public LogicalInstance getLogicalInstanceMand(String tenantId, String instanceId) {
        LogicalInstance li = InstancesHelper.getInstance(this.dbService, tenantId, instanceId);
        if (li == null) {
            throw new IllegalStateException(String.format("Unknown or missing logical instance: %s.%s", tenantId, instanceId));
        }
        return li;
    }

    private String arrayToStringCleaned(List<String> array) {
        if (array == null) {
            return null;
        }
        ListIterator<String> listIterator = array.listIterator();
        while (listIterator.hasNext()) {
            String next = listIterator.next();
            if (!StringUtils.isBlank((String)next)) continue;
            listIterator.remove();
        }
        return array.isEmpty() ? null : JSON.json(array);
    }

    private void checkLabelUnicityAcrossVirtualNetwork(String tenantId, String virtualNetworkId, String label) throws CodedException {
        this.checkLabelUnicityAcrossVirtualNetwork(tenantId, virtualNetworkId, label, null);
    }

    private void checkLabelUnicityAcrossVirtualNetwork(String tenantId, String virtualNetworkId, String label, String nodeId) throws CodedException {
        if (this.list(tenantId).stream().filter(p -> !p.id.equals(nodeId)).filter(p -> p.virtualNetworkId.equals(virtualNetworkId)).filter(p -> StringUtils.isBlank((String)p.label) ? StringUtils.isBlank((String)label) : p.label.equalsIgnoreCase(label)).count() > 0L) {
            throw new CodedException((InfoMessage.MessageCode)FMServerCodes.ERR_INSTANCE_LABEL_DUPLICATE, "An instance with the name '" + label + "' already exists in your virtual network.  Please choose an unique name.");
        }
    }

    public void checkIfInstanceCreatedAndLabelChanges(String tenantId, String instanceId, String instanceLabel) throws CodedException {
        PublicLogicalInstance existingInstance = this.list(tenantId).stream().filter(p -> p.id.equals(instanceId)).findFirst().orElse(null);
        if (existingInstance != null && !existingInstance.label.equals(instanceLabel)) {
            throw new CodedException((InfoMessage.MessageCode)FMServerCodes.ERR_INSTANCE_LABEL_CHANGE, "You cannot change the instance label once the instance has been created.");
        }
    }

    public void checkIfExternalURLIsValid(String externalURL) throws CodedException {
        String externalURLPattern = "^(http|https)://.*$";
        if (StringUtils.isNotBlank((String)externalURL) && !externalURL.matches(externalURLPattern)) {
            throw new CodedException((InfoMessage.MessageCode)FMServerCodes.ERR_INVALID_EXTERNAL_URL, "External URL needs to start with http(s)://.");
        }
    }

    public static class InitialPassword {
        public String password;
    }

    public static class InstanceLicense {
        public boolean hasLicense;
        public String license;
        public boolean usesSublicense;
        public String sublicenseId;
        public String sublicenseLabel;
    }

    public static class AWSKeypair {
        public String awsAccessKeyId;
        public String awsSecretAccessKey;
    }

    public static class AdminAPIKey {
        public String adminAPIKey;
    }
}

