/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.instances;

import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.PublicLogicalInstance;
import com.dataiku.fm.model.published.PublicProtoLogicalInstance;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.CreationDataUtils;
import com.dataiku.fm.server.instances.InstanceSettingsTemplateCRUDService;
import com.dataiku.fm.server.instances.InstancesCRUDService;
import com.dataiku.fm.server.instances.InstancesEventLogService;
import com.dataiku.fm.server.instances.NodesDirectoryUpdateService;
import com.dataiku.fm.server.instances.PhysicalInstanceCommandService;
import com.dataiku.fm.server.instances.PhysicalInstanceProvisioningService;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMUIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class InstancesController
extends DIPInternalControllerBase {
    @Autowired
    private FMUIAuthService uiAuthService;
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private InstancesCRUDService instancesService;
    @Autowired
    private PhysicalInstanceCommandService commandService;
    @Autowired
    private PhysicalInstanceProvisioningService reprovisionService;
    @Autowired
    private InstanceSettingsTemplateCRUDService istCRUDService;
    @Autowired
    private InstancesEventLogService eventLogService;
    @Autowired
    private NodesDirectoryUpdateService nodesDiredctoryUpdateService;

    @RequestMapping(value={"/api/ui/instances/list"})
    public void listTenantInstances(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        List<PublicLogicalInstance> ret = this.instancesService.list(authCtx.getTenantId());
        InstancesController.writeJSON((HttpServletResponse)resp, ret);
    }

    @RequestMapping(value={"/api/ui/instances/create"})
    public void createInstance(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instance) throws Exception {
        PublicProtoLogicalInstance ppli = (PublicProtoLogicalInstance)JSON.parse((String)instance, PublicProtoLogicalInstance.class);
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        PublicLogicalInstance pli = this.instancesService.create(authCtx.getTenantId(), ppli);
        InstancesController.writeJSON((HttpServletResponse)resp, (Object)pli);
    }

    @RequestMapping(value={"/api/ui/instances/get"})
    public void getInstance(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        InstancesController.writeJSON((HttpServletResponse)resp, (Object)this.instancesService.get(authCtx.getTenantId(), instanceId));
    }

    @RequestMapping(value={"/api/ui/instances/get-initial-admin-password"})
    public void getInitialPassword(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        InstancesController.writeJSON((HttpServletResponse)resp, (Object)this.instancesService.getInitialAdminPassword(authCtx.getTenantId(), instanceId));
    }

    @RequestMapping(value={"/api/ui/instances/reset-user-password"}, method={RequestMethod.POST})
    public void resetUserPassword(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId, @RequestParam String username, @RequestParam String password) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        InstancesController.writeJSON((HttpServletResponse)resp, this.commandService.resetUserPassword(authCtx, instanceId, username, password));
    }

    @RequestMapping(value={"/api/ui/instances/replay-setup-actions"}, method={RequestMethod.POST})
    public void replaySetupActions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        InstancesController.writeJSON((HttpServletResponse)resp, this.commandService.replaySetupActions(authCtx, instanceId));
    }

    @RequestMapping(value={"/api/ui/instances/update-nodes-directory"}, method={RequestMethod.POST})
    public void updateNodesDirectory(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        InstancesController.writeJSON((HttpServletResponse)resp, this.nodesDiredctoryUpdateService.updateNodesDirectoryOnNode_Future(authCtx, instanceId));
    }

    @RequestMapping(value={"/api/ui/instances/save"})
    public void saveInstance(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instance) throws Exception {
        PublicLogicalInstance dto = (PublicLogicalInstance)JSON.parse((String)instance, PublicLogicalInstance.class);
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        this.instancesService.checkIfInstanceCreatedAndLabelChanges(authCtx.getTenantId(), dto.id, dto.label);
        this.instancesService.checkIfExternalURLIsValid(dto.externalURL);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            InstancesController.writeJSON((HttpServletResponse)resp, (Object)this.instancesService.update(authCtx.getTenantId(), dto));
            rwt.commit();
        }
    }

    @RequestMapping(value={"/api/ui/instances/get-physical-instance-status"})
    public void getPhysicalInstanceStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        InstancesController.writeJSON((HttpServletResponse)resp, (Object)this.reprovisionService.getStatus(authCtx.getTenantId(), instanceId));
    }

    @RequestMapping(value={"/api/ui/instances/get-events-log"})
    public void getEventsLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        LogicalInstance li = this.instancesService.getInternal(authCtx.getTenantId(), instanceId);
        InstancesController.writeJSON((HttpServletResponse)resp, (Object)this.eventLogService.getInstanceLog(li, 100));
    }

    @RequestMapping(value={"/api/ui/instances/get-creation-data"})
    public void getCreationData(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        CreationDataUtils.InstanceCreationData ret = CreationDataUtils.getInstanceCreationData(authCtx.getTenantId());
        InstancesController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @RequestMapping(value={"/api/ui/instances/start-reprovision"})
    public void startReprovision(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        InstancesController.writeJSON((HttpServletResponse)resp, this.reprovisionService.startReprovision(authCtx, instanceId));
    }

    @RequestMapping(value={"/api/ui/instances/start-deprovision"})
    public void startDeprovision(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        InstancesController.writeJSON((HttpServletResponse)resp, this.reprovisionService.startDeprovision(authCtx, instanceId));
    }

    @RequestMapping(value={"/api/ui/instances/start-delete"})
    public void startDelete(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        InstancesController.writeJSON((HttpServletResponse)resp, this.reprovisionService.startDeleteInstance(authCtx, instanceId));
    }

    @RequestMapping(value={"/api/ui/instances/refresh-load-balancer"})
    public void refreshLoadBalancer(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        InstancesController.writeJSON((HttpServletResponse)resp, this.reprovisionService.refreshLoadBalancer(authCtx, instanceId));
    }

    @RequestMapping(value={"/api/ui/instances/start-physical-start"})
    public void startPhysicalStart(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        InstancesController.writeJSON((HttpServletResponse)resp, this.reprovisionService.startPhysicalStart(authCtx, instanceId));
    }

    @RequestMapping(value={"/api/ui/instances/start-physical-stop"})
    public void startPhysicalStop(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        InstancesController.writeJSON((HttpServletResponse)resp, this.reprovisionService.startPhysicalStop(authCtx, instanceId));
    }

    @RequestMapping(value={"/api/ui/instances/start-physical-reboot"})
    public void startPhysicalReboot(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        InstancesController.writeJSON((HttpServletResponse)resp, this.reprovisionService.startPhysicalReboot(authCtx, instanceId));
    }

    @RequestMapping(value={"/api/ui/instances/start-restart-dss"})
    public void startRestartDSS(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        InstancesController.writeJSON((HttpServletResponse)resp, this.reprovisionService.startDSSRestart(authCtx, instanceId));
    }

    @RequestMapping(value={"/api/ui/instances/fetch-agent-logs"})
    public void fetchAgentLogs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        InstancesController.writeJSON((HttpServletResponse)resp, this.instancesService.fetchAgentLogs(authCtx, instanceId));
    }

    @RequestMapping(value={"/api/ui/instances/read-agent-logs"})
    public void readAgentLogs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId, @RequestParam int nbLines) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        File agentLogFile = this.instancesService.getAgentLogFile(authCtx.getTenantId(), instanceId);
        SmartLogTail logTail = agentLogFile != null ? DKUtils.smartTailFile((File)agentLogFile, (int)nbLines) : new SmartLogTail();
        InstancesController.writeJSON((HttpServletResponse)resp, (Object)logTail);
    }

    @RequestMapping(value={"/api/ui/instances/download-agent-logs"})
    public void downloadAgentLogs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserNoXSRF(req);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        File agentLogFile = this.instancesService.getAgentLogFile(authCtx.getTenantId(), instanceId);
        if (agentLogFile != null) {
            resp.setContentType("text/plain; charset=UTF-8");
            try (FileInputStream fis = new FileInputStream(agentLogFile);){
                IOUtils.copy((InputStream)fis, (OutputStream)resp.getOutputStream());
            }
        } else {
            resp.setStatus(404);
            resp.getWriter().write("Agent log file not found.");
        }
    }

    @RequestMapping(value={"/api/ui/instances/disable-user"})
    public void disableUser(HttpServletRequest req, HttpServletResponse resp, @RequestParam String username, @RequestParam(value="instanceId", required=false) List<String> instanceIds) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        InstancesController.writeJSON((HttpServletResponse)resp, this.commandService.disableUser(authCtx, username, instanceIds));
    }

    static class SublicenseSummary {
        String id;
        String label;

        public SublicenseSummary() {
        }

        public SublicenseSummary(String label, String id) {
            this.label = label;
            this.id = id;
        }
    }

    public static class VirtualNetworkSummary {
        String id;
        String label;
        String publicDnsZone;
        String privateDnsZone;
        VirtualNetwork.HTTPSStrategy httpsStrategy;
        VirtualNetwork.HTTPStrategy httpStrategy;
        VirtualNetwork.DNSStrategy dnsStrategy;
        boolean isEnabled;

        public VirtualNetworkSummary() {
        }

        public VirtualNetworkSummary(String label, String id, VirtualNetwork.HTTPSStrategy httpsStrategy, VirtualNetwork.HTTPStrategy httpStrategy, boolean isEnabled, String publicDnsZone, String privateDnsZone, VirtualNetwork.DNSStrategy dnsStrategy) {
            this.label = label;
            this.id = id;
            this.httpsStrategy = httpsStrategy;
            this.httpStrategy = httpStrategy;
            this.isEnabled = isEnabled;
            this.publicDnsZone = publicDnsZone;
            this.privateDnsZone = privateDnsZone;
            this.dnsStrategy = dnsStrategy;
        }
    }

    public static class IdAndLabel {
        String id;
        String label;

        public IdAndLabel() {
        }

        public IdAndLabel(String id, String label) {
            this.id = id;
            this.label = label;
        }
    }
}

