/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.loadbalancers;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.fm.cloud.CloudDNSservice;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstancesController;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreationDataService {
    @Autowired
    private CloudDNSservice cloudDNSservice;

    public LoadBalancerCreationData getCreationData(String tenantId) {
        DatabaseAccessService dbService = (DatabaseAccessService)SpringUtils.getBean(DatabaseAccessService.class);
        LoadBalancerCreationData ret = new LoadBalancerCreationData();
        for (VirtualNetwork vn : dbService.listResults(VirtualNetwork.class, "SELECT vn from virtualnetwork vn where vn.tenant.id=?1", tenantId)) {
            FMSettings settings = FMApp.getFMSettingsUnsafe();
            String publicDnsZone = this.cloudDNSservice.getPublicDNSZoneDomain(vn);
            String privateDnsZone = this.cloudDNSservice.getPrivateDNSZoneDomain(vn);
            switch (settings.cloud) {
                case AWS: {
                    ret.virtualNetworks.add(new InstancesController.VirtualNetworkSummary(vn.getLabel(), vn.getId(), vn.getHttpsStrategy(), vn.getHttpStrategy(), vn.getAwsSecondSubnetId() != null, publicDnsZone, privateDnsZone, vn.getDnsStrategy()));
                    break;
                }
                case AZURE: {
                    ret.virtualNetworks.add(new InstancesController.VirtualNetworkSummary(vn.getLabel(), vn.getId(), vn.getHttpsStrategy(), vn.getHttpStrategy(), vn.getAzureSecondSubnet() != null, publicDnsZone, privateDnsZone, vn.getDnsStrategy()));
                }
            }
        }
        return ret;
    }

    public static class LoadBalancerCreationData {
        public List<InstancesController.VirtualNetworkSummary> virtualNetworks = new ArrayList<InstancesController.VirtualNetworkSummary>();
    }
}

