/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.monitoring;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.server.monitoring.AlertingTask;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.quartz.CronScheduleBuilder;
import org.quartz.DateBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.stereotype.Service;

@Service
public class AlertingSchedulerService {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.alerting.job.scheduler");
    private static final String ALERTING_JOB_GROUP = "fmalerting";
    private static final String ALERTING_CHECKS_JOB_KEY = "fmalerting-checks";
    private static final int ALERTING_JOB_FREQUENCY_IN_MIN_DEFAULT = 1;
    private static final String ALERTING_JOB_FREQUENCY_PROPERTY = "dku.fm.alerting.checks.frequencyInMin";
    private Scheduler scheduler;

    @PostConstruct
    public void init() {
        try {
            logger.info((Object)"Starting alerting scheduler service...");
            int alertingJobFrequency = DKUApp.getProperty((String)ALERTING_JOB_FREQUENCY_PROPERTY, (int)1);
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            this.scheduler.start();
            this.addScheduledTaskMinutes(AlertingTask.class, this.getAlertingJobKey(), alertingJobFrequency);
        }
        catch (Exception e) {
            logger.fatal((Object)"Alerting scheduler service could not be initialized properly.", (Throwable)e);
        }
    }

    private JobKey getAlertingJobKey() {
        return new JobKey(ALERTING_CHECKS_JOB_KEY);
    }

    private void addScheduledTaskMinutes(Class<? extends Job> clazz, JobKey jobKey, int frequencyInMinutes) throws SchedulerException {
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)String.format("0 */%s * * * ?", frequencyInMinutes)).withMisfireHandlingInstructionDoNothing();
        Date startAt = DateBuilder.futureDate((int)frequencyInMinutes, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.MINUTE);
        this.addScheduledTask(clazz, jobKey, (ScheduleBuilder<?>)scheduleBuilder, startAt);
    }

    private void addScheduledTask(Class<? extends Job> clazz, JobKey jobKey, ScheduleBuilder<?> scheduleBuilder, Date startAt) throws SchedulerException {
        JobDetail job = JobBuilder.newJob(clazz).withIdentity(jobKey).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobKey.getName() + "-trigger", ALERTING_JOB_GROUP).withSchedule(scheduleBuilder).startAt(startAt).build();
        this.scheduler.scheduleJob(job, trigger);
        this.scheduler.triggerJob(job.getKey());
        logger.info((Object)("Alerting scheduled task successfully added: " + job.getKey().toString()));
    }
}

