/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.publicapi;

import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.fm.model.published.DataVolumeSnapshotDTO;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.instances.PhysicalInstanceProvisioningService;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMPublicAPIAuthService;
import com.dataiku.fm.server.snapshots.SnapshotsCRUDService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PublicAPISnapshotsController
extends PublicAPIControllerBase {
    @Autowired
    private FMPublicAPIAuthService authService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private SnapshotsCRUDService snapshotsService;
    @Autowired
    private PhysicalInstanceProvisioningService provisioningService;

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances/{instanceId}/snapshots"}, method={RequestMethod.GET})
    public void listSnapshots(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        List<DataVolumeSnapshotDTO> ret = this.snapshotsService.list(tenantId, instanceId);
        PublicAPISnapshotsController.writeJSON((HttpServletResponse)resp, ret);
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances/{instanceId}/snapshots/{snapshotId}"}, method={RequestMethod.GET})
    public void getSnapshot(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId, @PathVariable String snapshotId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        DataVolumeSnapshotDTO ret = this.snapshotsService.get(tenantId, instanceId, snapshotId);
        PublicAPISnapshotsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances/{instanceId}/snapshots"}, method={RequestMethod.POST})
    public void createSnapshot(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId, @RequestParam(required=false) String reasonForSnapshot) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        DataVolumeSnapshotDTO ret = this.provisioningService.snapshot(tenantId, instanceId, reasonForSnapshot);
        PublicAPISnapshotsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances/{instanceId}/snapshots/{snapshotId}"}, method={RequestMethod.DELETE})
    public void deleteSnapshot(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId, @PathVariable String snapshotId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPISnapshotsController.writeJSON((HttpServletResponse)resp, this.provisioningService.startDeleteSnapshot(authCtx, instanceId, snapshotId));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instances/{instanceId}/snapshots/{snapshotId}/reprovision"}, method={RequestMethod.POST})
    public void reprovisionFromSnapshot(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String instanceId, @PathVariable String snapshotId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPISnapshotsController.writeJSON((HttpServletResponse)resp, this.provisioningService.startReprovisionFromPreviousSnapshot(authCtx, instanceId, snapshotId));
    }
}

