/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.security;

import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.server.security.FMPublicAPIAuthService;
import com.dataiku.fm.server.security.FMUIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class FMMetaAuthService {
    @Autowired
    private FMPublicAPIAuthService publicApi;
    @Autowired
    private FMUIAuthService ui;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.security.auth");

    public AuthCtx getFromAnyNoXSRF(HttpServletRequest req) throws DKUSecurityException, CodedException {
        try {
            if (req.getHeader("authorization") != null && req.getHeader("authorization").startsWith("Basic ")) {
                return this.publicApi.getUserMandatory(req);
            }
            return this.ui.getUserNoXSRF(req);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read authentication info ", (Throwable)e);
            throw new DKUSecurityException("Failed to read authentication info");
        }
    }

    public void verifyDebugAccess_NT(HttpServletRequest req) throws DKUSecurityException, CodedException {
        AuthCtx authCtx = this.getFromAnyNoXSRF(req);
        if (authCtx == null) {
            throw new DKUSecurityException("You are not allowed to call this");
        }
        if (!authCtx.isAdmin()) {
            throw new DKUSecurityException("You are not allowed to call this");
        }
        logger.debug((Object)"Debug call allowed via AuthCtx");
    }
}

