/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.simulator.publicapi;

import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.fm.simulator.CloudSimulatorService;
import com.dataiku.fm.simulator.model.CloudSimulatorState;
import com.dataiku.fm.simulator.model.CloudVMState;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PublicAPISimulatorController
extends PublicAPIControllerBase {
    private static final String RESPONSE_OK = "OK";
    @Autowired
    private CloudSimulatorService cloudSimulatorService;

    @RequestMapping(value={"/api/public/simulator"}, method={RequestMethod.GET})
    public void saveSimulatorState(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        PublicAPISimulatorController.writeJSON((HttpServletResponse)resp, (Object)this.cloudSimulatorService.saveState());
    }

    @RequestMapping(value={"/api/public/simulator"}, method={RequestMethod.PUT})
    public void loadSimulatorState(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        CloudSimulatorState state = (CloudSimulatorState)this.getRequestBodyAs(req, CloudSimulatorState.class);
        this.cloudSimulatorService.loadState(state);
        PublicAPISimulatorController.writeJSONString((HttpServletResponse)resp, (String)RESPONSE_OK);
    }

    @RequestMapping(value={"/api/public/simulator/vms/{vmId}"}, method={RequestMethod.GET})
    public void getVM(HttpServletRequest req, HttpServletResponse resp, @PathVariable String vmId) throws Exception {
        PublicAPISimulatorController.writeJSON((HttpServletResponse)resp, (Object)this.cloudSimulatorService.executeGetVM(vmId));
    }

    @RequestMapping(value={"/api/public/simulator/vms/{vmId}"}, method={RequestMethod.DELETE})
    public void deleteVM(HttpServletRequest req, HttpServletResponse resp, @PathVariable String vmId) throws Exception {
        this.cloudSimulatorService.executeDeleteVM(vmId);
        PublicAPISimulatorController.writeJSONString((HttpServletResponse)resp, (String)RESPONSE_OK);
    }

    @RequestMapping(value={"/api/public/simulator/vms/{vmId}"}, method={RequestMethod.PATCH})
    public void updateVM(HttpServletRequest req, HttpServletResponse resp, @PathVariable String vmId) throws Exception {
        UpdateVMArgs args = (UpdateVMArgs)this.getRequestBodyAs(req, UpdateVMArgs.class);
        this.cloudSimulatorService.executeUpdateVMState(vmId, args.state);
        PublicAPISimulatorController.writeJSONString((HttpServletResponse)resp, (String)RESPONSE_OK);
    }

    @RequestMapping(value={"/api/public/simulator/vms/{vmId}/actions/start-agent"}, method={RequestMethod.POST})
    public void startAgent(HttpServletRequest req, HttpServletResponse resp, @PathVariable String vmId) throws Exception {
        this.cloudSimulatorService.executeStartAgent(vmId);
        PublicAPISimulatorController.writeJSONString((HttpServletResponse)resp, (String)RESPONSE_OK);
    }

    @RequestMapping(value={"/api/public/simulator/vms/{vmId}/actions/stop-agent"}, method={RequestMethod.POST})
    public void stopAgent(HttpServletRequest req, HttpServletResponse resp, @PathVariable String vmId) throws Exception {
        this.cloudSimulatorService.executeStopAgent(vmId);
        PublicAPISimulatorController.writeJSONString((HttpServletResponse)resp, (String)RESPONSE_OK);
    }

    @RequestMapping(value={"/api/public/simulator/vms/{vmId}/actions/start-agent-heartbeat"}, method={RequestMethod.POST})
    public void startAgentHeartbeat(HttpServletRequest req, HttpServletResponse resp, @PathVariable String vmId) throws Exception {
        this.cloudSimulatorService.executeStartStopAgentHeartbeat(vmId, true);
        PublicAPISimulatorController.writeJSONString((HttpServletResponse)resp, (String)RESPONSE_OK);
    }

    @RequestMapping(value={"/api/public/simulator/vms/{vmId}/actions/stop-agent-heartbeat"}, method={RequestMethod.POST})
    public void stopAgentHeartbeat(HttpServletRequest req, HttpServletResponse resp, @PathVariable String vmId) throws Exception {
        this.cloudSimulatorService.executeStartStopAgentHeartbeat(vmId, false);
        PublicAPISimulatorController.writeJSONString((HttpServletResponse)resp, (String)RESPONSE_OK);
    }

    @RequestMapping(value={"/api/public/simulator/vms/{vmId}/actions/start"}, method={RequestMethod.POST})
    public void startVM(HttpServletRequest req, HttpServletResponse resp, @PathVariable String vmId) throws Exception {
        this.cloudSimulatorService.executeStartVM(vmId);
        PublicAPISimulatorController.writeJSONString((HttpServletResponse)resp, (String)RESPONSE_OK);
    }

    @RequestMapping(value={"/api/public/simulator/vms/{vmId}/actions/stop"}, method={RequestMethod.POST})
    public void stopVM(HttpServletRequest req, HttpServletResponse resp, @PathVariable String vmId) throws Exception {
        this.cloudSimulatorService.executeStopVM(vmId);
        PublicAPISimulatorController.writeJSONString((HttpServletResponse)resp, (String)RESPONSE_OK);
    }

    @RequestMapping(value={"/api/public/simulator/disks/{diskId}"}, method={RequestMethod.PATCH})
    public void updateDisk(HttpServletRequest req, HttpServletResponse resp, @PathVariable String diskId) throws Exception {
        UpdateDiskArgs args = (UpdateDiskArgs)this.getRequestBodyAs(req, UpdateDiskArgs.class);
        this.cloudSimulatorService.executeUpdateDisk(diskId, args.sizeGB, args.usedGB);
        PublicAPISimulatorController.writeJSONString((HttpServletResponse)resp, (String)RESPONSE_OK);
    }

    @RequestMapping(value={"/api/public/simulator/variables"}, method={RequestMethod.PATCH})
    public void updateVariables(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        Map variables = (Map)this.getRequestBodyAs(req, Map.class);
        this.cloudSimulatorService.executeUpdateVariables(variables);
        PublicAPISimulatorController.writeJSONString((HttpServletResponse)resp, (String)RESPONSE_OK);
    }

    private static class UpdateVMArgs {
        CloudVMState state;

        private UpdateVMArgs() {
        }
    }

    private static class UpdateDiskArgs {
        Integer sizeGB;
        Integer usedGB;

        private UpdateDiskArgs() {
        }
    }
}

