# Python<->Java mapping
from typing import Any, TYPE_CHECKING, List, Union
from dataikuapi.dss.llm import DSSLLMStreamedCompletionChunk, DSSLLMStreamedCompletionFooter, DSSLLMCompletionResponse, DSSLLMEmbeddingsResponse, DSSLLMImageGenerationResponse


if TYPE_CHECKING:
    from generated_sources.com.dataiku.dip.llm.io.commands.process_single_prompt_command.process_single_prompt_command import ProcessSinglePromptCommand
    from generated_sources.com.dataiku.dip.llm.io.commands.process_single_embedding_command.process_single_embedding_command import ProcessSingleEmbeddingCommand
    from generated_sources.com.dataiku.dip.llm.io.commands.process_single_image_generation_command.process_single_image_generation_command import ProcessSingleImageGenerationCommand
    from generated_sources.com.dataiku.dip.llm.io.commands.stream_response_chunk_or_footer.stream_response_chunk_or_footer import StreamResponseChunkOrFooter
    from generated_sources.com.dataiku.dip.llm.custom.custom_python_llm_client.start_custom_llm_server_command import StartCustomLLMServerCommand
    from generated_sources.com.dataiku.dip.llm.langchain.python_llm_server.start_agent_server_command import StartAgentServerCommand
    from generated_sources.com.dataiku.dip.llm.online.llm_client.completion_settings import CompletionSettings
    from generated_sources.com.dataiku.dip.llm.online.llm_client.embedding_query import EmbeddingQuery
    from generated_sources.com.dataiku.dip.llm.online.llm_client.embedding_settings import EmbeddingSettings
    from generated_sources.com.dataiku.dip.llm.online.llm_client.image_generation_query import ImageGenerationQuery
    from generated_sources.com.dataiku.dip.llm.online.llm_client.image_generation_response import ImageGenerationResponse
    from generated_sources.com.dataiku.dip.llm.online.llm_client.llm_mesh_trace_span import LLMMeshTraceSpan
    from generated_sources.com.dataiku.dip.llm.online.llm_client.single_completion_query import SingleCompletionQuery
    from generated_sources.com.dataiku.dip.llm.online.llm_client.simple_completion_response import SimpleCompletionResponse
    from generated_sources.com.dataiku.dip.llm.online.llm_client.simple_embedding_response import SimpleEmbeddingResponse
    from generated_sources.com.dataiku.dip.llm.online.llm_client.streamed_completion_response_chunk import StreamedCompletionResponseChunk
    from generated_sources.com.dataiku.dip.llm.online.llm_client.streamed_completion_response_footer import StreamedCompletionResponseFooter
else:
    StartCommand = Any
    ProcessPromptCommand = Any
    LLMPluginServerStartCommand = Any
    ProcessSingleEmbeddingCommand = Any
    ProcessSingleImageGenerationCommand = Any
    ProcessSinglePromptCommand = Any
    StartAgentServerCommand = Any
    StartCustomLLMServerCommand = Any
    StreamResponseChunkOrFooter = Any
    StreamedCompletionResponseChunk = Any
    StreamedCompletionResponseFooter = Any
    CompletionSettings = Any
    EmbeddingQuery = Any
    EmbeddingSettings = Any
    ImageGenerationQuery = Any
    ImageGenerationResponse = Any
    SingleCompletionQuery = Any
    SimpleCompletionResponse = Any
    SimpleEmbeddingResponse = Any
    LLMMeshTraceSpan = Any

CompletionResponse = Union[str, DSSLLMCompletionResponse, SimpleCompletionResponse]
EmbeddingResponse = Union[List[float], DSSLLMEmbeddingsResponse, SimpleEmbeddingResponse]
PluginImageGenerationResponse = Union[List[str], str, List[bytes], bytes, DSSLLMImageGenerationResponse, ImageGenerationResponse]
StreamCompletionResponse = Union[str, DSSLLMStreamedCompletionChunk, DSSLLMStreamedCompletionFooter, StreamResponseChunkOrFooter, StreamedCompletionResponseChunk, StreamedCompletionResponseFooter]
