(function() {
    'use strict';

    const app = angular.module("dataiku.fm.maintenance", ["dataiku.services", "dataiku.filters", "dataiku.fm.dialogs"]);

    app.controller("DiagnosesController", function($scope, Dialogs, FMAPI, FutureProgressModal, WT1) {
        $scope.diagnoses = [];
        
        $scope.startDiagnosis = function() {
            WT1.event("fm-diagnosis-start", {});
    
            FMAPI.maintenance.startDiagnosis().success(function(response){
                FutureProgressModal.show($scope, response, "Diagnosis in progress...").then((diagnosis) => {
                    diagnosis.url = "/api/ui/maintenance/diagnoses/" + diagnosis.name + "/zip"
                    $scope.diagnoses.unshift(diagnosis)                                    
                });
            }).error(setErrorInScope.bind($scope));
        }

        $scope.getDiagnoses = function() {
            FMAPI.maintenance.getDiagnoses().success(function(response){
                $scope.diagnoses = []
                response.forEach(diagnosis => {
                    diagnosis.url = "/api/ui/maintenance/diagnoses/" + diagnosis.name + "/zip"
                    $scope.diagnoses.push(diagnosis)
                });
            }).error(setErrorInScope.bind($scope));
        }

        $scope.deleteDiagnosis = function(diagnosis) {
            Dialogs.confirm($scope, "Confirm deletion", "Are you sure you want to delete the diagnosis " + diagnosis.name + "? Once deleted you will not be able to recover it!").then(() => {
                FMAPI.maintenance.deleteDiagnosis(diagnosis).success(function(){
                    var index = $scope.diagnoses.indexOf(diagnosis);
                    if (index !== -1) {
                        $scope.diagnoses.splice(index, 1);
                    }
                }).error(setErrorInScope.bind($scope));
            });
        }

        $scope.getDiagnoses();
    });
}());
