(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    /**
     * (!) This directive previously was in static/dataiku/js/simple_report/chart_dragdrop.js
     * ---- Additonal API ----
     * Ability to specify which element inside the chart-drag-drop-list-item directive should be draggable
     * - Add the additional `specify-drag-trigger` attribute with the directive
     * - Set the `trigger-drag` attribute to all elements that should trigger a dragstart
     * As a result all nodes inside your `specify-drag-trigger` element will be dragged
     * But only those with a `trigger-drag` attribute will trigger a dragstart
     */
    app.directive('chartDragDropListItem', () => {
        let shouldBeDragged = true;
        return {
            controller: 'ChartDragDropController',
            link: function($scope, element, attrs) {

                $(element).attr('draggable', 'true');

                // if specifics trigger-drags were declared, check if the currently pressed element can trigger a dragstart
                const specifyDragTrigger = attrs.specifyDragTrigger !== undefined;
                if (specifyDragTrigger) {
                    element[0].addEventListener('mousedown', function(e) {
                        let node = e.target;
                        while (node) {
                            // found the trigger-drag attr. in one of the parent, we can drag
                            if (node.hasAttribute('trigger-drag')) {
                                shouldBeDragged = true;
                                break;
                            }
                            // reached the final node w/o finding the 'trigger-drag' attr. we can't drag
                            if (node.hasAttribute('specify-drag-trigger')) {
                                shouldBeDragged = false;
                                break;
                            }
                            node = node.parentElement;
                        }
                    });
                }

                element[0].addEventListener('dragstart', function(e) {
                    // if currently pressed element shouldn't trigger a drag we stop
                    if (specifyDragTrigger && !shouldBeDragged) {
                        e.preventDefault();
                        return;
                    }

                    const draggedElement = $(e.target);

                    $scope.$apply(function() {
                        $scope.activeDragDrop.active = true;
                        $scope.setDragActive();
                        $scope.activeDragDrop.moveFromList = $scope.$eval(attrs.chartDragDropListItem);
                        $scope.activeDragDrop.moveFromListIndex = draggedElement.index();
                        $scope.activeDragDrop.data = $scope.activeDragDrop.moveFromList[$scope.activeDragDrop.moveFromListIndex];
                        $scope.activeDragDrop.draggedElementToHide = draggedElement;
                    });

                    e.dataTransfer.effectAllowed = 'move';
                    e.dataTransfer.setData(window.dkuDragType, JSON.stringify($scope.activeDragDrop.data));

                    this.classList.add('dragging');
                    return false;
                }, false);

                element[0].addEventListener('dragend', function(e) {
                    this.classList.remove('dragging');
                    return false;
                }, false);
            }
        };
    });
})();
