/* global describe, beforeEach, it, inject, expect, module */

describe("partition deps", function(){
    beforeEach(module('dataiku.aiSqlGeneration'));
    beforeEach(module("dataiku.logger"));
	beforeEach(module("dataiku.charts"));
    beforeEach(module('dataiku.recipes'));
	beforeEach(module("dataiku.mock"));

	it("has proper constants", function(){
		inject(function(PartitionDeps) {
			expect(PartitionDeps.timeRangeFromModes).toBeDefined();
			expect(PartitionDeps.timeRangeFromModes.length).toBe(2);
		});
	});

	it ("can autocomplete time range 1", inject(function(PartitionDeps) {
		var pdep = { "func" : "time_range" }
		var odims = [{"out" : "ds1", "odim" : "day" }]
		PartitionDeps.autocomplete(pdep, odims);
		expect(pdep.params.fromMode).toBe("RELATIVE_OFFSET")
	}));

	it ("can serialize", inject(function(PartitionDeps) {
		var pdep = { "func" : "equals", "idim": "d1", "input":"da1",
		  "$$output" : {"out" : "dataset2", "odim" : "x" } }

		var ret = PartitionDeps.prepareForSerialize(pdep);
		expect(ret.odim).toBe("x")
		expect(ret.out).toBe("dataset2")
	}));

	it ("can serialize 2", inject(function(PartitionDeps) {
		var pdep = { "func" : "time_range", "idim": "d1", "input":"da1",
		  "$$output" : {"label": "current time" } }

		var ret = PartitionDeps.prepareForSerialize(pdep);
		expect(ret.odim).toBeUndefined();
		expect(ret.out).toBeUndefined();
	}));
})

describe("RecipesUtils", function(){
	beforeEach(module("dataiku.logger"));
	beforeEach(module("dataiku.mock"));
	beforeEach(module('dataiku.recipes'));
	it("getWT1LoggableRecipeEventParams properly for main use case", function(){
		inject(function(RecipesUtils) {
			expect(RecipesUtils.getWT1LoggableRecipeEventParams({params: {
				customConfig: {
					foo: "fooV",
					bar: "barV",
					zde: null,
					obj: {
						alpha: "alpha"
					}
				}
			}}, {params: [
				{
					name: "foo",
					wt1Loggable: false
				},
				{
					name: "bar",
					wt1Loggable: true
				},
				{
					name: "zde",
					wt1Loggable: true
				},
				{
					name: "obj",
					wt1Loggable: true
				}
			]})).toEqual({
				"recipeEventParam-bar": "barV",
				"recipeEventParam-zde": null,
				"recipeEventParam-obj": {
					alpha: "alpha"
				}
			});
		})
	});
	it("getWT1LoggableRecipeEventParams properly for unexpected case", function(){
		inject(function(RecipesUtils) {
			expect(RecipesUtils.getWT1LoggableRecipeEventParams({params: {customConfig: null}}, {params: [
				{
					name: "foo",
					wt1Loggable: false
				},
			]
			})).toEqual({});
			expect(RecipesUtils.getWT1LoggableRecipeEventParams({params: null}, {params: [
				{
					name: "foo",
					wt1Loggable: false
				},
			]
			})).toEqual({});
			expect(RecipesUtils.getWT1LoggableRecipeEventParams(null, {params: [
				{
					name: "foo",
					wt1Loggable: false
				},
			]
			})).toEqual({});
			expect(RecipesUtils.getWT1LoggableRecipeEventParams({params: {
				customConfig: {
					foo: "fooV",
					bar: "barV",
				}
			}}, {params: null})).toEqual({});
			expect(RecipesUtils.getWT1LoggableRecipeEventParams({params: {
				customConfig: {
					foo: "fooV",
					bar: "barV",
				}
			}}, {params: []})).toEqual({});
			expect(RecipesUtils.getWT1LoggableRecipeEventParams({params: {
				customConfig: {
					foo: "fooV",
					bar: "barV",
				}
			}}, null)).toEqual({});
		});
	});
	it("getWT1OutputAppendModeTracking properly for nominal case - some append mode", function(){
		inject(function(RecipesUtils) {
			const recipe = {
				outputs: {
					main: { 
						items: [ 
							{ appendMode: false }, 
							{ appendMode: true } 
						] 
					},
					yolo: { 
						items: [ 
							{ appendMode: false } 
						] 
					}
				}
			};
			const expected_params = { 
				recipeAnyOutputAppendMode: true
			};
			expect(RecipesUtils.getWT1OutputAppendModeTracking(recipe)).toEqual(expected_params);
		})
	});
	it("getWT1OutputAppendModeTracking properly for nominal case - no append mode", function(){
		inject(function(RecipesUtils) {
			const recipe = {
				outputs: {
					main: { 
						items: [ 
							{ appendMode: false }, 
							{ appendMode: false } 
						] 
					},
					yolo: { 
						items: [ 
							{ appendMode: false } 
						] 
					}
				}
			};
			const expected_params = { 
				recipeAnyOutputAppendMode: false
			};
			expect(RecipesUtils.getWT1OutputAppendModeTracking(recipe)).toEqual(expected_params);
		})
	});

	it("getWT1OutputAppendModeTracking properly for unexpected case - no outputs", function(){
		inject(function(RecipesUtils) {
			const recipe = {
				outputs: {}
			};
			const expected_params = { 
				recipeAnyOutputAppendMode: false
			};
			expect(RecipesUtils.getWT1OutputAppendModeTracking(recipe)).toEqual(expected_params);
		})
	});
	it("getWT1OutputAppendModeTracking properly for unexpected case - no output for role", function(){
		inject(function(RecipesUtils) {
			const recipe = {
				outputs: {
					main: { 
						items: [] 
					},
				}
			};
			const expected_params = { 
				recipeAnyOutputAppendMode: false
			};
			expect(RecipesUtils.getWT1OutputAppendModeTracking(recipe)).toEqual(expected_params);
		})
	});
	it("getWT1OutputAppendModeTracking properly for unexpected case - appendMode undefined for output", function(){
		inject(function(RecipesUtils) {
			const recipe = {
				outputs: {
					main: { 
						items: [{}] 
					},
				}
			};
			const expected_params = { 
				recipeAnyOutputAppendMode: false
			};
			expect(RecipesUtils.getWT1OutputAppendModeTracking(recipe)).toEqual(expected_params);
		})
	});

	it("getWT1OutputAppendModeTracking properly for error case - recipe undefined", function(){
		inject(function(RecipesUtils) {
			const recipe = undefined;
			const expected_params = {};
			expect(RecipesUtils.getWT1OutputAppendModeTracking(recipe)).toEqual(expected_params);
		})
	});
	it("getWT1OutputAppendModeTracking properly for error case - outputs undefined", function(){
		inject(function(RecipesUtils) {
			const recipe = {};
			const expected_params = {};
			expect(RecipesUtils.getWT1OutputAppendModeTracking(recipe)).toEqual(expected_params);
		})
	});
	it("getWT1OutputAppendModeTracking properly for error case - outputs not object", function(){
		inject(function(RecipesUtils) {
			const NOT_AN_OBJECT = 0;
			const recipe = {
				outputs: NOT_AN_OBJECT
			};
			const expected_params = {};
			expect(RecipesUtils.getWT1OutputAppendModeTracking(recipe)).toEqual(expected_params);
		})
	});
	it("getWT1OutputAppendModeTracking properly for error case - output items undefined", function(){
		inject(function(RecipesUtils) {
			const recipe = {
				outputs: {
					main: {}
				}
			};
			const expected_params = {};
			expect(RecipesUtils.getWT1OutputAppendModeTracking(recipe)).toEqual(expected_params);
		})
	});
	it("getWT1OutputAppendModeTracking properly for error case - output items not iterable", function(){
		inject(function(RecipesUtils) {
			const NOT_ITERABLE = 0;
			const recipe = {
				outputs: {
					main: { 
						items: NOT_ITERABLE
					}
				}
			};
			const expected_params = {};
			expect(RecipesUtils.getWT1OutputAppendModeTracking(recipe)).toEqual(expected_params);
		})
	});
})