from dataiku.base.utils import package_is_at_least

def binom_test(k, n, **kwargs):
    import scipy
    if package_is_at_least(scipy, "1.7"):
        from scipy.stats import binomtest
        return binomtest(round(k), n, **kwargs).pvalue
    else:
        from scipy.stats import binom_test
        return binom_test(k, n, **kwargs)