import logging

import pandas as pd

logger = logging.getLogger(__name__)


def is_mlflow_model(model_folder_context):
    return model_folder_context.isfile("MLmodel")


def load_external_model_meta(model_folder_context):
    mim = model_folder_context.read_json("mlflow_imported_model.json")
    int_to_label_map = {}
    label_to_int_map = {}
    labels_list = []

    if "classLabels" in mim:
        for index in range(len(mim["classLabels"])):
            label = mim["classLabels"][index]["label"]
            int_to_label_map[index] = label
            label_to_int_map[label] = index
            labels_list.append(index)

        mim["intToLabelMap"] = int_to_label_map
        mim["labelToIntMap"] = label_to_int_map
        mim["labelsList"] = labels_list
        logger.info("ltim: %s" % int_to_label_map)

    mim["model_folder_context"] = model_folder_context

    return mim


def convert_prediction_response_to_dataframe(response):
    """
    Convert the prediction response from a DSS API Node into a DataFrame compatible with evaluation

    :param response:
    :type response: dict
    :return:
    :rtype: pd.DataFrame
    """
    results = response["results"]
    results = [_convert_response_item_to_record(x) for x in results]
    return pd.DataFrame(results)


def _convert_response_item_to_record(item):
    """

    :param item:
    :type item: dict
    :return:
    :rtype: dict
    """
    result = {"prediction": item["prediction"]}
    if "probas" in item:
        result.update({"proba_{}".format(k): v for k, v in item["probas"].items()})
    return result


def convert_dataframe_to_records(input_df):
    """
    Convert the pd.DataFrame to a list of json compatible with DSS API Node input format

    :param input_df:
    :type input_df: pd.DataFrame
    :return:
    :rtype: list[dict]
    """
    return [{"features": x} for x in input_df.to_dict("records")]
