import numpy as np
import pandas as pd

from dataiku.base.utils import safe_unicode_str
from dataiku.doctor.utils import datetime_to_epoch


class DataDriftParams(object):
    def __init__(self, columns, nb_bins, compute_histograms, confidence_level):
        self.columns = columns
        self.nb_bins = nb_bins
        self.compute_histograms = compute_histograms
        self.confidence_level = confidence_level

    @staticmethod
    def build(params):
        return DataDriftParams(params["columns"], params["nbBins"],
                               params["computeHistograms"], params["confidenceLevel"])


def cast_as_numeric(series):
    """
    Treat a series as numerical and converts datetime into epoch if necessary
    """
    try:
        return series.astype(np.float64)
    except Exception:
        return datetime_to_epoch(pd.to_datetime(series, utc=True).dt.tz_localize(None).astype('datetime64[ns]'))

def cast_as_string(series):
    """
    Treat a series as string
    """
    if pd.api.types.is_numeric_dtype(series):
        return series.apply(lambda x: '%g'%x)
    else:
        return series.apply(lambda x: safe_unicode_str(x))
