/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.generator.values.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.ModelPart;

public class GeneratedValuesImpl
implements GeneratedValues {
    private final Map<ModelPart, Object> generatedValuesMap;

    public GeneratedValuesImpl(List<? extends ModelPart> generatedProperties) {
        this.generatedValuesMap = new IdentityHashMap<ModelPart, Object>(generatedProperties.size());
    }

    @Override
    public void addGeneratedValue(ModelPart modelPart, Object value) {
        this.generatedValuesMap.put(modelPart, value);
    }

    @Override
    public Object getGeneratedValue(ModelPart modelPart) {
        return this.generatedValuesMap.get(modelPart);
    }

    @Override
    public List<Object> getGeneratedValues(List<? extends ModelPart> modelParts) {
        if (CollectionHelper.isEmpty(modelParts)) {
            return Collections.emptyList();
        }
        ArrayList<Object> generatedValues = new ArrayList<Object>(modelParts.size());
        for (ModelPart modelPart : modelParts) {
            assert (this.generatedValuesMap.containsKey(modelPart));
            generatedValues.add(this.generatedValuesMap.get(modelPart));
        }
        return generatedValues;
    }
}

