/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.sso;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.SSOSettings;
import com.dataiku.dip.security.auth.UserIdentity;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.security.jwt.BadTokenException;
import com.dataiku.dip.security.jwt.JWTClaimsSetVerifierFactory;
import com.dataiku.dip.security.jwt.JWTError;
import com.dataiku.dip.security.jwt.JwtVerificationService;
import com.dataiku.dip.security.jwt.OpenIDClaimsSetVerifierFactory;
import com.dataiku.dip.security.jwt.ProxyResourceRetriever;
import com.dataiku.dip.security.jwt.RemoteJWKException;
import com.dataiku.dip.security.sso.OpenIDErrorCode;
import com.dataiku.dip.security.sso.SSORedirectURL;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JOSEException;
import com.dataiku.dss.shadelib.com.nimbusds.jose.jwk.source.JWKSource;
import com.dataiku.dss.shadelib.com.nimbusds.jose.jwk.source.JWKSourceBuilder;
import com.dataiku.dss.shadelib.com.nimbusds.jose.proc.BadJOSEException;
import com.dataiku.dss.shadelib.com.nimbusds.jose.proc.SecurityContext;
import com.dataiku.dss.shadelib.com.nimbusds.jose.util.ResourceRetriever;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.JWT;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.JWTClaimsSet;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ResponseType;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.Scope;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.TokenRequest;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.auth.Secret;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.ClientID;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.State;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.Nonce;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.Prompt;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;

public class OpenIDHelper {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth.sso");
    private static final String EMAIL_CLAIM = "email";
    private static final String EMAIL_VERIFIED_CLAIM = "email_verified";
    public static final String SSO_OPENID_EMAIL_VERIFIED_ENABLED = "dku.sso.openid.emailVerifiedCheckEnabled";
    public static final String JWK_URL_PROPERTY_HTTP_CONNECT_TIMEOUT = "dku.openid.jwkurl.defaultHttpConnectTimeout";
    public static final String JWK_URL_PROPERTY_HTTP_READ_TIMEOUT = "dku.openid.jwkurl.defaultHttpReadTimeout";
    public static final String JWK_URL_PROPERTY_HTTP_SIZE_LIMIT = "dku.openid.jwkurl.defaultHttpSizeLimit";
    private final SSOSettings ssoSettings;
    private final JwtVerificationService jwtVerificationService;
    private final PasswordEncryptionService passwordEncryptionService;
    private final ProxySettings proxySettingsDecrypted;
    private JWKSource<SecurityContext> jwkSource;
    private ResourceRetriever resourceRetriever;
    private URL jwksUri;

    public OpenIDHelper(SSOSettings ssoSettings, JwtVerificationService jwtVerificationService, PasswordEncryptionService passwordEncryptionService, ProxySettings proxySettings) {
        this.ssoSettings = ssoSettings;
        this.jwtVerificationService = jwtVerificationService;
        this.passwordEncryptionService = passwordEncryptionService;
        ProxySettings ps = proxySettings.deepCopy();
        if (passwordEncryptionService != null) {
            ps.decryptFields(passwordEncryptionService);
        }
        this.proxySettingsDecrypted = ps;
    }

    public Pair<SSORedirectURL, String> getRedirectURL(String oidcClientURL) throws URISyntaxException {
        Object scope = this.ssoSettings.openIDParams.scope;
        if (!Arrays.asList(((String)scope).split(" ")).contains("openid")) {
            scope = "openid " + (String)scope;
        }
        String state = UUID.randomUUID().toString();
        CodeVerifier codeVerifier = new CodeVerifier();
        AuthenticationRequest.Builder requestBuilder = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(((String)scope).split(" ")), new ClientID(this.ssoSettings.openIDParams.clientId), new URI(oidcClientURL + "/login/openid-redirect-uri/")).endpointURI(new URI(this.ssoSettings.openIDParams.authorizationEndpoint)).state(new State(state)).nonce(new Nonce(state));
        String prompt = Optional.ofNullable(this.ssoSettings.openIDParams.prompt).orElse("");
        if (StringUtils.isNotBlank((String)prompt)) {
            String[] promptList = (String[])Arrays.stream(prompt.split(" ")).map(String::trim).filter(StringUtils::isNotBlank).toArray(String[]::new);
            requestBuilder.prompt(new Prompt(promptList));
        }
        if (this.ssoSettings.openIDParams.usePKCE) {
            requestBuilder = requestBuilder.codeChallenge(codeVerifier, CodeChallengeMethod.S256);
            return new Pair((Object)new SSORedirectURL(requestBuilder.build().toURI().toString(), state), (Object)codeVerifier.getValue());
        }
        return new Pair((Object)new SSORedirectURL(requestBuilder.build().toURI().toString(), state), null);
    }

    public UserIdentity getUserIdentity(String code, String state, String oidcClientURL, String codeVerifier) throws URISyntaxException, CodedException, MalformedURLException, java.text.ParseException {
        OIDCTokenResponse oidcTokenResponse;
        SSOSettings.OpenIDParams openIDParams = this.ssoSettings.openIDParams;
        AuthorizationCodeGrant authorizationCodeGrant = codeVerifier != null ? new AuthorizationCodeGrant(new AuthorizationCode(code), new URI(oidcClientURL + "/login/openid-redirect-uri/"), new CodeVerifier(codeVerifier)) : new AuthorizationCodeGrant(new AuthorizationCode(code), new URI(oidcClientURL + "/login/openid-redirect-uri/"));
        ClientSecretPost clientAuth = switch (openIDParams.tokenEndpointAuthMethod) {
            case SSOSettings.OpenIDTokenEndpointAuthMethod.CLIENT_SECRET_POST -> new ClientSecretPost(new ClientID(openIDParams.clientId), new Secret(openIDParams.getClientSecretDecrypted(this.passwordEncryptionService)));
            default -> new ClientSecretBasic(new ClientID(openIDParams.clientId), new Secret(openIDParams.getClientSecretDecrypted(this.passwordEncryptionService)));
        };
        try {
            TokenRequest tokenRequest = new TokenRequest(URI.create(openIDParams.tokenEndpoint), (ClientAuthentication)clientAuth, (AuthorizationGrant)authorizationCodeGrant);
            logger.debugV("Send token request to IDP token endpoint %s, with auth method %s and useGlobalProxy=%s", new Object[]{openIDParams.tokenEndpoint, openIDParams.tokenEndpointAuthMethod, openIDParams.useGlobalProxy});
            oidcTokenResponse = this.getTokens(tokenRequest);
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Couldn't exchange the authorisation code for an ID token.", new Object[0]);
            throw new CodedException((InfoMessage.MessageCode)OpenIDErrorCode.ERR_OPENID_IDP_EXCHANGE_CODE_FAILURE, "Couldn't exchange the authorization code. Please contact your administrator.", (Throwable)e);
        }
        JWKSource<SecurityContext> jwkSource = this.getJWKSource(new URL(openIDParams.jwksUri), openIDParams.useGlobalProxy);
        try {
            this.verifyIDToken(oidcTokenResponse.getOIDCTokens().getIDToken(), openIDParams, jwkSource, state);
        }
        catch (UnauthorizedException e) {
            logger.errorV((Throwable)((Object)e), "Received an invalid ID Token '%s'", new Object[]{oidcTokenResponse.getOIDCTokens().getIDTokenString()});
            throw new CodedException((InfoMessage.MessageCode)OpenIDErrorCode.ERR_OPENID_IDP_INVALID_ID_TOKEN, "Invalid ID Token. Please contact your administrator.", (Throwable)((Object)e));
        }
        JWTClaimsSet jwtClaimsSet = oidcTokenResponse.getOIDCTokens().getIDToken().getJWTClaimsSet();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("ID Token validated successfully. The user claims are : \n" + JSON.pretty((Object)jwtClaimsSet.toJSONObject())));
        }
        UserIdentity userIdentity = new UserIdentity(UserSourceType.LOCAL_NO_AUTH, OpenIDHelper.getLogin(jwtClaimsSet, openIDParams));
        userIdentity.email = OpenIDHelper.getEmailClaim(jwtClaimsSet, openIDParams);
        userIdentity.displayName = jwtClaimsSet.getStringClaim(openIDParams.claimKeyDisplayName);
        if (openIDParams.enableGroups) {
            userIdentity.groupNames = Optional.ofNullable(jwtClaimsSet.getStringArrayClaim(openIDParams.claimKeyGroups)).map(Arrays::asList).map(HashSet::new).orElse(new HashSet());
        }
        return userIdentity;
    }

    private static String getLogin(JWTClaimsSet jwtClaimsSet, SSOSettings.OpenIDParams openIDParams) throws java.text.ParseException {
        String openidLogin = jwtClaimsSet.getStringClaim(openIDParams.claimKeyIdentifier);
        if (StringUtils.isBlank((String)openidLogin)) {
            logger.warn((Object)("The claim '" + openIDParams.claimKeyIdentifier + "' is blank, using 'sub' instead."));
            openidLogin = jwtClaimsSet.getSubject();
        }
        if (openIDParams.lowercaseIdentifier) {
            return openidLogin.toLowerCase();
        }
        return openidLogin;
    }

    @CheckForNull
    private static String getEmailClaim(JWTClaimsSet jwtClaimsSet, SSOSettings.OpenIDParams openIDParams) throws java.text.ParseException, CodedException {
        String email = jwtClaimsSet.getStringClaim(openIDParams.claimKeyEmail);
        boolean isEmailVerified = Optional.ofNullable(jwtClaimsSet.getBooleanClaim(EMAIL_VERIFIED_CLAIM)).orElse(true);
        boolean emailMustBeVerified = Boolean.parseBoolean(DKUApp.getProperty(SSO_OPENID_EMAIL_VERIFIED_ENABLED, "true"));
        if (!isEmailVerified) {
            if (emailMustBeVerified) {
                logger.info((Object)("The email '" + email + "' is marked as unverified by the IDP and should not be trusted"));
                if (EMAIL_CLAIM.equals(openIDParams.claimKeyIdentifier)) {
                    throw new CodedException((InfoMessage.MessageCode)OpenIDErrorCode.ERR_OPENID_UNVERIFIED_EMAIL, "Invalid ID Token. Your email is marked as unverified from the IDP. Verify your email or please contact your administrator.");
                }
                return null;
            }
            logger.warn((Object)("The email '" + email + "' is marked as unverified by the IDP and should not be trusted according to the specification. Although the dip property dku.sso.openid.emailVerifiedCheckEnabled is currently disabling this verification and exposing your DSS instance. Please consider removing this property if not needed."));
        }
        return email;
    }

    public boolean isPKCEEnabled() {
        return this.ssoSettings.openIDParams.usePKCE;
    }

    private OIDCTokenResponse getTokens(TokenRequest tokenRequest) throws IOException, ParseException, DKUSecurityException {
        HTTPRequest httpRequest = tokenRequest.toHTTPRequest();
        if (this.ssoSettings.openIDParams.useGlobalProxy) {
            ProxyUtils.applyProxySettings(this.proxySettingsDecrypted, httpRequest);
        }
        HTTPResponse httpResponse = httpRequest.send();
        if (logger.isInfoEnabled() && !httpResponse.indicatesSuccess()) {
            logger.infoV("Authorization code grant flow failed to exchange the authorization code. Status %s: HTTP response content: %s", new Object[]{httpResponse.getStatusCode(), httpResponse.getContent()});
        }
        OIDCTokenResponse response = OIDCTokenResponse.parse((HTTPResponse)httpResponse);
        if (logger.isTraceEnabled()) {
            try {
                logger.trace((Object)("Got tokens: " + String.valueOf(response.toJSONObject())));
            }
            catch (Exception e) {
                logger.error((Object)"Couldn't print token response", (Throwable)e);
            }
        }
        if (!response.indicatesSuccess()) {
            TokenErrorResponse errorResponse = response.toErrorResponse();
            throw new DKUSecurityException("Failed to acquire a successful OAuth2 token response: " + errorResponse.toJSONObject().toJSONString());
        }
        return response.toSuccessResponse();
    }

    private void verifyIDToken(JWT idToken, SSOSettings.OpenIDParams openIDParams, JWKSource<SecurityContext> keySource, String nonce) throws UnauthorizedException {
        try {
            DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
            jwtProcessor.setJWSKeySelector(this.jwtVerificationService.selectKeysFromKidOrAlg(keySource));
            jwtProcessor.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)JWTClaimsSetVerifierFactory.createJwtClaimsSetVerifierMulti().add(JWTClaimsSetVerifierFactory.createExpVerifier()).add(JWTClaimsSetVerifierFactory.createIssueAtTimeVerifier()).add(JWTClaimsSetVerifierFactory.createNotBeforeTimeVerifier()).add(JWTClaimsSetVerifierFactory.createIssuerVerifier(openIDParams.issuer)).add(JWTClaimsSetVerifierFactory.createAudienceVerifier(openIDParams.clientId)).add(OpenIDClaimsSetVerifierFactory.createNonceVerifier(nonce)));
            jwtProcessor.process(idToken, null);
        }
        catch (BadTokenException e) {
            throw new UnauthorizedException(e.getMessage(), e.getCode().getCode(), (Throwable)((Object)e));
        }
        catch (RemoteJWKException e) {
            throw new UnauthorizedException(e.getMessage(), e.getCode().getCode(), (Throwable)((Object)e));
        }
        catch (BadJOSEException e) {
            throw new UnauthorizedException(e.getMessage(), JWTError.ERR_JWT_INVALID_SIGNATURE.name(), e);
        }
        catch (JOSEException e) {
            throw new UnauthorizedException(e.getMessage(), "UNKNOWN", e);
        }
    }

    private JWKSource<SecurityContext> getJWKSource(URL jwksUri, boolean useProxy) {
        if (this.jwkSource == null || !this.jwksUri.toString().equals(jwksUri.toString()) || ((ProxyResourceRetriever)this.resourceRetriever).isUsingProxy() != useProxy) {
            ProxyResourceRetriever resourceRetriever = new ProxyResourceRetriever(DKUApp.getProperty(JWK_URL_PROPERTY_HTTP_CONNECT_TIMEOUT, 500), DKUApp.getProperty(JWK_URL_PROPERTY_HTTP_READ_TIMEOUT, 500), DKUApp.getProperty(JWK_URL_PROPERTY_HTTP_SIZE_LIMIT, 51200), this.proxySettingsDecrypted, useProxy);
            JWKSourceBuilder jwkSourceBuilder = JWKSourceBuilder.create((URL)jwksUri, (ResourceRetriever)resourceRetriever);
            this.jwtVerificationService.dkuDefaultJwkSrcConfiguration((JWKSourceBuilder<SecurityContext>)jwkSourceBuilder, jwksUri.toString());
            this.jwkSource = jwkSourceBuilder.build();
            this.jwksUri = jwksUri;
            this.resourceRetriever = resourceRetriever;
        }
        return this.jwkSource;
    }
}

