/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.transactions.fs.ConcreteRelFileAttribute;
import com.dataiku.dip.transactions.fs.FileContent;
import com.dataiku.dip.transactions.fs.FileContentFactory;
import com.dataiku.dip.transactions.fs.ProtectedFiles;
import com.dataiku.dip.transactions.fs.ReadWriteFSBase;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ZipReadFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileAttribute;
import com.dataiku.dip.transactions.fs.ifaces.RelFileOutputStream;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class NativeFS
extends ReadWriteFSBase {
    protected final File root;
    protected boolean rejectSymlinks;
    private final boolean atomicWrite;
    private boolean skipFileTypeCheck;
    protected ProtectedFiles protectedFiles = ProtectedFiles.TRANSACTION_PROTECTED_FILES;
    private final boolean measurePerformance = DKUApp.getParams().getBoolParam("dku.debugging.toggles.nativeFS.measurePerformance", false);
    private final boolean logGetAttributes = DKUApp.getParams().getBoolParam("dku.debugging.toggles.nativeFS.logGetAttributes", false);
    private final long mkdirDelayMs = DKUApp.getParams().getLongParam("dku.debugging.delays.nativeFS.mkdir", 0L);
    private final long writeStreamNoMkdirDelayMs = DKUApp.getParams().getLongParam("dku.debugging.delays.nativeFS.writeStreamNoMkdir", 0L);
    private final long getAttributesDelayMs = DKUApp.getParams().getLongParam("dku.debugging.delays.nativeFS.getAttributes", 0L);
    private Function<File, File> temporaryFileProvider = file -> new File(file.getPath() + ".tmp." + SecretKeyGenerator.generateSmall());
    private static final Logger logger = Logger.getLogger((String)"dku.transactions.nativefs");

    private NativeFS(File root, boolean skipFileTypeCheck, boolean atomicWrite, boolean rejectSymlinks, FileContentFactory fileContentFactory) throws IOException {
        super(fileContentFactory);
        if (!root.isDirectory()) {
            throw new FileNotFoundException(root.getAbsolutePath() + " is not a directory");
        }
        this.root = root;
        this.skipFileTypeCheck = skipFileTypeCheck;
        this.rejectSymlinks = rejectSymlinks;
        this.atomicWrite = DKUtils.isOsWindows() ? false : atomicWrite;
    }

    public static Builder from(File root) {
        return new Builder().root(root);
    }

    public File getRoot() {
        return this.root;
    }

    void setSkipFileTypeCheck(boolean skipFileTypeCheck) {
        this.skipFileTypeCheck = skipFileTypeCheck;
    }

    @VisibleForTesting
    void setTemporaryFileProvider(Function<File, File> temporaryFileProvider) {
        this.temporaryFileProvider = temporaryFileProvider;
    }

    private void ensureNoSymlinkSingleFile(RelFile rf) throws IOException {
        if (!this.rejectSymlinks) {
            return;
        }
        File file = rf.resolve(this.root);
        this.ensureNoSymlinkSingleFile(file);
    }

    private void ensureNoSymlinkSingleFile(File file) throws IOException {
        if (!this.rejectSymlinks) {
            return;
        }
        BasicFileAttributes attrs = NativeFS.readAttributesImpl(file, LinkOption.NOFOLLOW_LINKS);
        if (attrs == null) {
            return;
        }
        if (attrs.isSymbolicLink()) {
            throw new IOException("Rejected symlink: " + String.valueOf(file.toPath()));
        }
    }

    private void ensureNoSymlinks(RelFile rf) throws IOException {
        if (!this.rejectSymlinks) {
            return;
        }
        for (RelFile parentRf : rf.walk()) {
            this.ensureNoSymlinkSingleFile(parentRf);
        }
    }

    @Override
    public List<RelFile> listFilesUnordered(RelFile directory) throws IOException {
        this.protectedFiles.assertNotProtected(directory);
        this.ensureNoSymlinks(directory);
        ArrayList<RelFile> out = new ArrayList<RelFile>();
        File realFile = directory.resolve(this.root);
        if (realFile.isDirectory()) {
            String[] names = realFile.list();
            if (names == null) {
                throw new IOException("Unable to list directory: " + realFile.getAbsolutePath());
            }
            for (String name : names) {
                BasicFileAttributes attrs;
                RelFile newRelFile = directory.append(name);
                if (this.protectedFiles.isProtected(newRelFile) || !this.skipFileTypeCheck && ((attrs = NativeFS.readAttributesImpl(newRelFile.resolve(this.root), new LinkOption[0])) == null || !attrs.isDirectory() && !attrs.isRegularFile())) continue;
                try {
                    this.ensureNoSymlinkSingleFile(newRelFile);
                }
                catch (IOException e) {
                    continue;
                }
                out.add(newRelFile);
            }
        } else {
            throw new IOException(String.valueOf(directory) + " is not a directory");
        }
        return out;
    }

    public ZipReadFS readZip(RelFile file) throws IOException {
        this.protectedFiles.assertNotProtected(file);
        this.ensureNoSymlinks(file);
        return new ZipReadFS(this.resolve(file));
    }

    @Override
    public FileContent readContentUnsafe(RelFile file) throws IOException {
        this.protectedFiles.assertNotProtected(file);
        this.ensureNoSymlinks(file);
        File resolvedFile = file.resolve(this.root);
        BasicFileAttributes attrs = NativeFS.readAttributesImpl(resolvedFile, new LinkOption[0]);
        if (attrs == null || attrs.isDirectory()) {
            throw new IOException("Not a file: " + String.valueOf(file));
        }
        if (!attrs.isRegularFile()) {
            return this.fileContentFactory.fromUncompressedBytes(new byte[0]);
        }
        return this.fileContentFactory.fromUncompressedStreamSupplier(() -> new FileInputStream(resolvedFile), attrs.size());
    }

    @Nullable
    private static BasicFileAttributes readAttributesImpl(File file, LinkOption ... options) throws IOException {
        BasicFileAttributes bfa;
        try {
            bfa = Files.readAttributes(file.toPath(), BasicFileAttributes.class, options);
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (IOException e) {
            if (!file.exists()) {
                return null;
            }
            throw e;
        }
        return bfa;
    }

    @Override
    @Nullable
    public RelFileAttribute getAttributes(RelFile file) throws IOException {
        if (this.getAttributesDelayMs > 0L) {
            DKUtils.unsafeSleep((long)this.getAttributesDelayMs);
        }
        if (this.logGetAttributes) {
            logger.info((Object)("NativeFS.getAttributes: " + String.valueOf(this.resolve(file))));
        }
        DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtxIf(this.measurePerformance, "dku.core.fs.native.getAttributes");
        try {
            this.protectedFiles.assertNotProtected(file);
            try {
                this.ensureNoSymlinks(file);
            }
            catch (IOException e) {
                RelFileAttribute relFileAttribute = null;
                if (tctx != null) {
                    tctx.close();
                }
                return relFileAttribute;
            }
            File resolvedFile = file.resolve(this.root);
            BasicFileAttributes bfa = NativeFS.readAttributesImpl(resolvedFile, new LinkOption[0]);
            if (bfa == null) {
                RelFileAttribute relFileAttribute = null;
                return relFileAttribute;
            }
            if (bfa.isRegularFile()) {
                ConcreteRelFileAttribute concreteRelFileAttribute = new ConcreteRelFileAttribute(file, RelFileAttribute.FileType.FILE, bfa.lastModifiedTime().toMillis(), bfa.size());
                return concreteRelFileAttribute;
            }
            if (bfa.isDirectory()) {
                ConcreteRelFileAttribute concreteRelFileAttribute = new ConcreteRelFileAttribute(file, RelFileAttribute.FileType.DIRECTORY, -1L, -1L);
                return concreteRelFileAttribute;
            }
            ConcreteRelFileAttribute concreteRelFileAttribute = new ConcreteRelFileAttribute(file, RelFileAttribute.FileType.FILE, bfa.lastModifiedTime().toMillis(), 0L);
            return concreteRelFileAttribute;
        }
        finally {
            if (tctx != null) {
                try {
                    tctx.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Override
    public boolean deleteFile(RelFile file) throws IOException {
        this.protectedFiles.assertNotProtected(file);
        this.ensureNoSymlinks(file);
        File resolved = file.resolve(this.root);
        if (resolved.isFile()) {
            resolved.delete();
        }
        return !resolved.exists();
    }

    @Override
    public boolean deleteDirectory(RelFile directory) throws IOException {
        this.protectedFiles.assertNotProtected(directory);
        this.ensureNoSymlinks(directory);
        File resolved = directory.resolve(this.root);
        if (resolved.isDirectory()) {
            try {
                DKUFileUtils.deleteDirectory((File)resolved);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return !resolved.exists();
    }

    @Override
    public boolean makeDirectory(RelFile directory) throws IOException {
        if (this.mkdirDelayMs > 0L) {
            DKUtils.unsafeSleep((long)this.mkdirDelayMs);
        }
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtxIf(this.measurePerformance, "dku.core.fs.native.makeDirectory");){
            this.protectedFiles.assertNotProtected(directory);
            this.ensureNoSymlinks(directory);
            File resolved = directory.resolve(this.root);
            resolved.mkdirs();
            boolean bl = resolved.isDirectory();
            return bl;
        }
    }

    @Override
    public void writeBytes(RelFile file, byte[] bytes) throws IOException {
        if (file.getParent() != null) {
            this.makeDirectory(file.getParent());
        }
        try (RelFileOutputStream os = this.writeStreamNoMkdir(file);){
            ((OutputStream)((Object)os)).write(bytes);
        }
    }

    @Override
    public RelFileOutputStream writeStreamNoMkdir(RelFile rfile) throws IOException {
        FileOutputStream fos;
        File tmpFile;
        if (this.writeStreamNoMkdirDelayMs > 0L) {
            DKUtils.unsafeSleep((long)this.writeStreamNoMkdirDelayMs);
        }
        this.protectedFiles.assertNotProtected(rfile);
        this.ensureNoSymlinks(rfile);
        final File nativeFile = rfile.resolve(this.root);
        if (this.atomicWrite) {
            tmpFile = this.temporaryFileProvider.apply(nativeFile);
            this.ensureNoSymlinkSingleFile(tmpFile);
            fos = new FileOutputStream(tmpFile);
        } else {
            tmpFile = null;
            BasicFileAttributes attrs = NativeFS.readAttributesImpl(nativeFile, new LinkOption[0]);
            if (attrs != null && !attrs.isDirectory() && !attrs.isRegularFile()) {
                DKUFileUtils.forceDelete((File)nativeFile);
            }
            fos = new FileOutputStream(nativeFile);
        }
        return new RelFileOutputStream(rfile, fos){
            boolean closed;
            {
                super(file, os);
                this.closed = false;
            }

            public void close() throws IOException {
                if (!this.closed) {
                    this.closed = true;
                    super.close();
                    if (tmpFile != null) {
                        if (nativeFile.exists()) {
                            DKUFileUtils.forceDelete((File)nativeFile);
                        }
                        FileUtils.moveFile((File)tmpFile, (File)nativeFile);
                    }
                }
            }
        };
    }

    @Override
    public void writeContentUnsafeNoMkdir(RelFile rfile, FileContent content) throws IOException {
        try (RelFileOutputStream os = this.writeStreamNoMkdir(rfile);
             InputStream is = content.getAsNewStream();){
            IOUtils.copyLarge((InputStream)is, (OutputStream)((Object)os), (byte[])new byte[65536]);
        }
    }

    public File resolve(RelFile f) {
        return f.resolve(this.root);
    }

    public RelFile relativize(File file) throws IOException {
        String relativized = this.root.toPath().relativize(file.toPath()).toString();
        if (DKUtils.isOsWindows()) {
            relativized = relativized.replace('\\', '/');
        }
        return RelFile.fromPath(relativized);
    }

    @Override
    public void moveFile(RelFile src, RelFile dst) throws IOException {
        File to;
        File from;
        if (!this.exists(src)) {
            throw new IOException(String.valueOf(src) + " doesn't exist");
        }
        this.ensureNoSymlinks(dst);
        if (dst.isRoot()) {
            throw new IOException("/ is not a valid destination filename");
        }
        if (dst.getParent() != null) {
            this.makeDirectory(dst.getParent());
        }
        if (!src.equals(dst) && !(from = src.resolve(this.root)).renameTo(to = dst.resolve(this.root))) {
            throw new IOException("Unable to rename " + String.valueOf(from) + " into " + String.valueOf(to));
        }
    }

    public static class Builder {
        private File root;
        private boolean skipFileTypeCheck = DKUApp.getParams().getBoolParam("dku.core.fs.native.skipFileTypeCheck", true);
        private boolean atomicWrite = true;
        private boolean rejectSymlinks = DKUApp.getParams().getBoolParam("dku.core.fs.checkSymlinksAtReadTime", false);
        private FileContentFactory fileContentFactory = FileContentFactory.DEFAULT;

        public Builder root(File root) {
            this.root = root;
            return this;
        }

        public Builder skipFileTypeCheck(boolean skipFileTypeCheck) {
            this.skipFileTypeCheck = skipFileTypeCheck;
            return this;
        }

        public Builder atomicWrite(boolean atomicWrite) {
            this.atomicWrite = atomicWrite;
            return this;
        }

        public Builder rejectSymlinks(boolean rejectSymlinks) {
            this.rejectSymlinks = rejectSymlinks;
            return this;
        }

        public Builder fileContentFactory(FileContentFactory fileContentFactory) {
            this.fileContentFactory = fileContentFactory;
            return this;
        }

        public NativeFS build() throws IOException {
            return new NativeFS(this.root, this.skipFileTypeCheck, this.atomicWrite, this.rejectSymlinks, this.fileContentFactory);
        }
    }
}

