/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ExpireUtils {
    public static String getExpires(Date date) {
        return new SimpleDateFormat("yyyyMMdd").format(date);
    }

    public static String getExpiresFromNow(int days) {
        long expires = System.currentTimeMillis() + (long)days * 1000L * 86400L;
        return ExpireUtils.getExpires(new Date(expires));
    }

    public static Date parseStr(String expires) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        sdf.setTimeZone(TimeZone.getDefault());
        sdf.setLenient(false);
        return sdf.parse(expires);
    }

    public static Date parseStrAsExpires(String expires) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        sdf.setTimeZone(TimeZone.getDefault());
        sdf.setLenient(false);
        Date d = sdf.parse(expires);
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getDefault());
        cal.setTime(d);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.add(5, 1);
        return cal.getTime();
    }

    public static String renewExpires(String expires, int additionalDays) throws ParseException {
        Date date = ExpireUtils.parseStr(expires);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, additionalDays);
        return ExpireUtils.getExpires(cal.getTime());
    }
}

