/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud;

import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.fm.cloud.CloudInstanceServiceInterface;
import com.dataiku.fm.cloud.PhysicalInstanceCloudState;
import com.dataiku.fm.cloud.aws.AWSCloudInstanceService;
import com.dataiku.fm.cloud.azure.AzureCloudInstanceService;
import com.dataiku.fm.cloud.gcp.GCPCloudInstanceService;
import com.dataiku.fm.model.db.DataVolumeSnapshot;
import com.dataiku.fm.model.db.InstanceSettingsTemplate;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.PhysicalDataVolume;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.PublicPhysicalInstanceStatus;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.simulator.CloudSimulatorService;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.mail.MessagingException;

public class CloudInstanceService
implements CloudInstanceServiceInterface {
    private CloudInstanceServiceInterface adapter;

    @PostConstruct
    public void init() {
        this.adapter = CloudInstanceService.createAdapter();
        SpringUtils.getInstance().autowire((Object)this.adapter);
    }

    @Override
    public void checkInstanceCreation(VirtualNetwork vn, InstanceSettingsTemplate ist) {
        this.adapter.checkInstanceCreation(vn, ist);
    }

    @Override
    public PhysicalDataVolume createInitialPhysicalDataVolume(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li) {
        return this.adapter.createInitialPhysicalDataVolume(rwt, li);
    }

    @Override
    public PhysicalDataVolume createInitialPhysicalDataVolumeFromExternalSnapshot(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li, String externalSnapshotId) throws CodedException {
        return this.adapter.createInitialPhysicalDataVolumeFromExternalSnapshot(rwt, li, externalSnapshotId);
    }

    @Override
    public PhysicalDataVolume createPhysicalDataVolumeFromSnapshot(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li, String snapshotId) {
        return this.adapter.createPhysicalDataVolumeFromSnapshot(rwt, li, snapshotId);
    }

    @Override
    public DataVolumeSnapshot createPhysicalDataVolumeSnapshot(LogicalInstance li, String snapshotType, String description) {
        return this.adapter.createPhysicalDataVolumeSnapshot(li, snapshotType, description);
    }

    @Override
    public void deletePhysicalDataVolumeSnapshot(DataVolumeSnapshot dataVolumeSnapshot, LogicalInstance logicalInstance) {
        this.adapter.deletePhysicalDataVolumeSnapshot(dataVolumeSnapshot, logicalInstance);
    }

    @Override
    public void deletePhysicalDataVolume(PhysicalDataVolume physicalDataVolume, LogicalInstance li) {
        this.adapter.deletePhysicalDataVolume(physicalDataVolume, li);
    }

    @Override
    public String createPhysicalInstance(LogicalInstance li, DKUtils.SmartLogTailBuilder smartLogTail) throws MessagingException, IOException, InterruptedException {
        return this.adapter.createPhysicalInstance(li, smartLogTail);
    }

    @Override
    public boolean growPhysicalDataVolume(LogicalInstance li, double growthFactor) {
        return this.adapter.growPhysicalDataVolume(li, growthFactor);
    }

    @Override
    public void terminatePhysicalInstance(PhysicalInstance pi) {
        this.adapter.terminatePhysicalInstance(pi);
    }

    @Override
    public void startPhysicalInstance(PhysicalInstance pi) {
        this.adapter.startPhysicalInstance(pi);
    }

    @Override
    public void stopPhysicalInstance(PhysicalInstance pi) {
        this.adapter.stopPhysicalInstance(pi);
    }

    @Override
    public void rebootPhysicalInstance(PhysicalInstance pi) {
        this.adapter.rebootPhysicalInstance(pi);
    }

    @Override
    public void configurePhysicalInstanceBeforeStartupPhase(PhysicalInstance physicalInstance) {
        this.adapter.configurePhysicalInstanceBeforeStartupPhase(physicalInstance);
    }

    @Override
    public void configurePhysicalInstanceAfterStartupPhase(PhysicalInstance pi) {
        this.adapter.configurePhysicalInstanceAfterStartupPhase(pi);
    }

    @Override
    public Collection<PhysicalInstanceCloudState> getPhysicalInstancesCloudState(Tenant tenant, Collection<PhysicalInstance> piList) {
        return this.adapter.getPhysicalInstancesCloudState(tenant, piList);
    }

    @Override
    public void fillPhysicalStatusWithCloudSpecificData(PhysicalInstance pi, PhysicalDataVolume pdv, PublicPhysicalInstanceStatus status) {
        this.adapter.fillPhysicalStatusWithCloudSpecificData(pi, pdv, status);
    }

    private static CloudInstanceServiceInterface createAdapter() {
        if (FMApp.ENABLE_CLOUD_SIMULATOR) {
            return ((CloudSimulatorService)SpringUtils.getBean(CloudSimulatorService.class)).createInstanceService();
        }
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        switch (settings.cloud) {
            case AWS: {
                return new AWSCloudInstanceService();
            }
            case AZURE: {
                return new AzureCloudInstanceService();
            }
            case GCP: {
                return new GCPCloudInstanceService();
            }
        }
        throw new IllegalStateException("Invalid cloud type: " + String.valueOf((Object)settings.cloud));
    }
}

