/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.model.db;

import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.settings.Cloud;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Entity(name="virtualnetwork")
public class VirtualNetwork {
    @Id
    private String id;
    private String label;
    @Column(columnDefinition="text")
    private String description;
    @ManyToOne(fetch=FetchType.LAZY)
    private Tenant tenant;
    private String fmVisibleURL;
    @ManyToOne(fetch=FetchType.LAZY)
    private CloudAccount cloudAccount = null;
    @Enumerated(value=EnumType.STRING)
    private VirtualNetworkMode mode;
    private String managedCidr;
    @Enumerated(value=EnumType.STRING)
    private PeeringState peeringState;
    private String awsVpcId;
    private String awsPeeringConnectionId;
    private String awsRegion;
    private String awsAvailabilityZone;
    private String awsSubnetId;
    private String awsSecondSubnetId;
    private String awsSecurityGroups;
    private String awsDefaultSecurityGroup;
    private String autoCreatedAwsSecurityGroups;
    private String azureVnId;
    private String azureRgName;
    private String azureSubnet;
    private String azureSecondSubnet;
    private String azureRgNameForCreatedResources;
    private String azureRegion;
    private String azurePeeringConnectionId;
    private String gcpProjectId;
    private String gcpProjectIdForCreatedResources;
    private String gcpNetwork;
    private String gcpSubnetwork;
    private String gcpRegion;
    private String gcpZone;
    private String gcpPeeringConnectionId;
    @Column(columnDefinition="text")
    private String gcpNetworkTags;
    private boolean awsAssignPublicIP;
    private boolean azureAssignPublicIP;
    private Boolean gcpAssignPublicIP;
    @Enumerated(value=EnumType.STRING)
    private DNSStrategy dnsStrategy = DNSStrategy.NONE;
    @Nullable
    private String awsRoute53PrivateIPZoneId;
    @Nullable
    private String awsRoute53PublicIPZoneId;
    private String azureDnsZoneId;
    private String gcpCloudDnsPrivateIPZoneId;
    private String gcpCloudDnsPublicIPZoneId;
    @Enumerated(value=EnumType.STRING)
    private HTTPSStrategy httpsStrategy = HTTPSStrategy.NONE;
    @Enumerated(value=EnumType.STRING)
    private HTTPStrategy httpStrategy = HTTPStrategy.DISABLE;
    public String contactMail;
    private Boolean managedNodesDirectory;
    private String eventServerNodeLabel;
    private String governServerNodeLabel;
    @Enumerated(value=EnumType.STRING)
    private NodesDirectoryDeployerMode nodesDirectoryDeployerMode = NodesDirectoryDeployerMode.NO_MANAGED_DEPLOYER;
    @Column(columnDefinition="text")
    private String cloudTags;

    public String getFMVisibleURL() {
        return this.fmVisibleURL;
    }

    public void setFMVisibleURL(String fmVisibleURL) {
        this.fmVisibleURL = fmVisibleURL;
    }

    public String getManagedCidr() {
        return this.managedCidr;
    }

    public void setManagedCidr(String managedCidr) {
        this.managedCidr = managedCidr;
    }

    public String getAwsDefaultSecurityGroup() {
        return this.awsDefaultSecurityGroup;
    }

    public void setAwsDefaultSecurityGroup(String awsDefaultSecurityGroup) {
        this.awsDefaultSecurityGroup = awsDefaultSecurityGroup;
    }

    public String getGovernServerNodeLabel() {
        return this.governServerNodeLabel;
    }

    public void setGovernServerNodeLabel(String governServerNodeLabel) {
        this.governServerNodeLabel = governServerNodeLabel;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Nonnull
    public Tenant getTenant() {
        return this.tenant;
    }

    public void setTenant(@Nonnull Tenant tenant) {
        this.tenant = tenant;
    }

    @Nonnull
    public CloudAccount getCloudAccountOrVirtualCloudAccount() {
        if (this.cloudAccount == null) {
            return this.tenant.getVirtualCloudAccount(FMApp.getFMSettingsUnsafe());
        }
        return this.cloudAccount;
    }

    public void setCloudAccount(CloudAccount cloudAccount) {
        this.cloudAccount = cloudAccount;
    }

    public VirtualNetworkMode getMode() {
        return this.mode;
    }

    public void setMode(VirtualNetworkMode mode) {
        this.mode = mode;
    }

    public PeeringState getPeeringState() {
        return this.peeringState != null ? this.peeringState : PeeringState.NONE;
    }

    public void setPeeringState(PeeringState externalPeering) {
        this.peeringState = externalPeering;
    }

    public String getAwsVpcId() {
        return this.awsVpcId;
    }

    public void setAwsVpcId(String awsVpcId) {
        this.awsVpcId = awsVpcId;
    }

    public String getAwsPeeringConnectionId() {
        return this.awsPeeringConnectionId;
    }

    public void setAwsPeeringConnectionId(String awsPeeringConnectionId) {
        this.awsPeeringConnectionId = awsPeeringConnectionId;
    }

    public String getAwsRegion() {
        if (this.awsRegion == null) {
            FMSettings settings = FMApp.getFMSettingsUnsafe();
            if (settings.cloud == Cloud.AWS) {
                return settings.awsSettings.regionId;
            }
        }
        return this.awsRegion;
    }

    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    public String getAwsAvailabilityZone() {
        return this.awsAvailabilityZone;
    }

    public void setAwsAvailabilityZone(String awsAvailabilityZone) {
        this.awsAvailabilityZone = awsAvailabilityZone;
    }

    public String getAwsSubnetId() {
        return this.awsSubnetId;
    }

    public void setAwsSubnetId(String awsSubnetId) {
        this.awsSubnetId = awsSubnetId;
    }

    public String getAwsSecondSubnetId() {
        return this.awsSecondSubnetId;
    }

    public void setAwsSecondSubnetId(String awsSecondSubnetId) {
        this.awsSecondSubnetId = awsSecondSubnetId;
    }

    public String getAwsSecurityGroups() {
        return this.awsSecurityGroups;
    }

    public void setAwsSecurityGroups(String awsSecurityGroups) {
        this.awsSecurityGroups = awsSecurityGroups;
    }

    public String getAzureVnId() {
        return this.azureVnId;
    }

    public void setAzureVnId(String azureVnId) {
        this.azureVnId = azureVnId;
    }

    public String getAzureRegion() {
        if (this.azureRegion == null) {
            FMSettings settings = FMApp.getFMSettingsUnsafe();
            if (settings.cloud == Cloud.AZURE) {
                return settings.azureSettings.regionId;
            }
        }
        return this.azureRegion;
    }

    public void setAzureRegion(String azureRegion) {
        this.azureRegion = azureRegion;
    }

    public String getAzureRgName() {
        return this.azureRgName;
    }

    public void setAzureRgName(String azureRgName) {
        this.azureRgName = azureRgName;
    }

    public String getAzurePeeringConnectionId() {
        return this.azurePeeringConnectionId;
    }

    public void setAzurePeeringConnectionId(String azurePeeringConnectionId) {
        this.azurePeeringConnectionId = azurePeeringConnectionId;
    }

    public String getAzureRgNameForCreatedResources() {
        return this.azureRgNameForCreatedResources;
    }

    public void setAzureRgNameForCreatedResources(String azureRgNameForCreatedResources) {
        this.azureRgNameForCreatedResources = azureRgNameForCreatedResources;
    }

    public String getAzureSubnet() {
        return this.azureSubnet;
    }

    public void setAzureSubnet(String azureSubnet) {
        this.azureSubnet = azureSubnet;
    }

    public String getAzureSecondSubnet() {
        return this.azureSecondSubnet;
    }

    public void setAzureSecondSubnet(String azureSecondSubnet) {
        this.azureSecondSubnet = azureSecondSubnet;
    }

    public String getGcpProjectId() {
        return this.gcpProjectId;
    }

    public void setGcpProjectId(String gcpProjectId) {
        this.gcpProjectId = gcpProjectId;
    }

    public String getGcpProjectIdForCreatedResources() {
        return this.gcpProjectIdForCreatedResources;
    }

    public void setGcpProjectIdForCreatedResources(String gcpProjectId) {
        this.gcpProjectIdForCreatedResources = gcpProjectId;
    }

    public String getGcpNetwork() {
        return this.gcpNetwork;
    }

    public void setGcpNetwork(String gcpNetwork) {
        this.gcpNetwork = gcpNetwork;
    }

    public String getGcpSubnetwork() {
        return this.gcpSubnetwork;
    }

    public void setGcpSubnetwork(String gcpSubnetwork) {
        this.gcpSubnetwork = gcpSubnetwork;
    }

    public String getGcpRegion() {
        return this.gcpRegion;
    }

    public void setGcpRegion(String gcpRegion) {
        this.gcpRegion = gcpRegion;
    }

    public String getGcpZone() {
        return this.gcpZone;
    }

    public void setGcpZone(String gcpZone) {
        this.gcpZone = gcpZone;
    }

    public String getGcpPeeringConnectionId() {
        return this.gcpPeeringConnectionId;
    }

    public void setGcpPeeringConnectionId(String gcpPeeringConnectionId) {
        this.gcpPeeringConnectionId = gcpPeeringConnectionId;
    }

    public String getGcpNetworkTags() {
        return this.gcpNetworkTags;
    }

    public void setGcpNetworkTags(String gcpNetworkTags) {
        this.gcpNetworkTags = gcpNetworkTags;
    }

    public DNSStrategy getDnsStrategy() {
        return this.dnsStrategy;
    }

    public void setDnsStrategy(DNSStrategy dnsStrategy) {
        this.dnsStrategy = dnsStrategy;
    }

    public String getContactMail() {
        return this.contactMail;
    }

    public void setContactMail(String contactMail) {
        this.contactMail = contactMail;
    }

    public HTTPSStrategy getHttpsStrategy() {
        return this.httpsStrategy;
    }

    public void setHttpsStrategy(HTTPSStrategy httpsStrategy) {
        this.httpsStrategy = httpsStrategy;
    }

    public HTTPStrategy getHttpStrategy() {
        return this.httpStrategy;
    }

    public void setHttpStrategy(HTTPStrategy httpStrategy) {
        this.httpStrategy = httpStrategy;
    }

    public boolean isAwsAssignPublicIP() {
        return this.awsAssignPublicIP;
    }

    public void setAwsAssignPublicIP(boolean awsAssignPublicIP) {
        this.awsAssignPublicIP = awsAssignPublicIP;
    }

    public void setAzureAssignPublicIP(boolean azureAssignPublicIP) {
        this.azureAssignPublicIP = azureAssignPublicIP;
    }

    public boolean isAzureAssignPublicIP() {
        return this.azureAssignPublicIP;
    }

    public void setGcpAssignPublicIP(boolean gcpAssignPublicIP) {
        this.gcpAssignPublicIP = gcpAssignPublicIP;
    }

    public boolean isGcpAssignPublicIP() {
        return this.gcpAssignPublicIP != null && this.gcpAssignPublicIP != false;
    }

    @Nullable
    public String getAwsRoute53PrivateIPZoneId() {
        return this.awsRoute53PrivateIPZoneId;
    }

    public void setAwsRoute53PrivateIPZoneId(@Nullable String awsRoute53PrivateIPZoneId) {
        this.awsRoute53PrivateIPZoneId = awsRoute53PrivateIPZoneId;
    }

    @Nullable
    public String getAwsRoute53PublicIPZoneId() {
        return this.awsRoute53PublicIPZoneId;
    }

    public void setAwsRoute53PublicIPZoneId(@Nullable String awsRoute53PublicIPZoneId) {
        this.awsRoute53PublicIPZoneId = awsRoute53PublicIPZoneId;
    }

    public String getAzureDnsZoneId() {
        return this.azureDnsZoneId;
    }

    public void setAzureDnsZoneId(String azureDnsZoneId) {
        this.azureDnsZoneId = azureDnsZoneId;
    }

    public String getGcpCloudDnsPrivateIPZoneId() {
        return this.gcpCloudDnsPrivateIPZoneId;
    }

    public void setGcpCloudDnsPrivateIPZoneId(String gcpCloudDnsPrivateIPZoneId) {
        this.gcpCloudDnsPrivateIPZoneId = gcpCloudDnsPrivateIPZoneId;
    }

    public String getGcpCloudDnsPublicIPZoneId() {
        return this.gcpCloudDnsPublicIPZoneId;
    }

    public void setGcpCloudDnsPublicIPZoneId(String gcpCloudDnsPublicIPZoneId) {
        this.gcpCloudDnsPublicIPZoneId = gcpCloudDnsPublicIPZoneId;
    }

    public String getAutoCreatedAwsSecurityGroups() {
        return this.autoCreatedAwsSecurityGroups;
    }

    public void setAutoCreatedAwsSecurityGroups(String autoCreatedAwsSecurityGroups) {
        this.autoCreatedAwsSecurityGroups = autoCreatedAwsSecurityGroups;
    }

    public boolean isManagedNodesDirectory() {
        return this.managedNodesDirectory != null && this.managedNodesDirectory != false;
    }

    public void setManagedNodesDirectory(boolean managedNodesDirectory) {
        this.managedNodesDirectory = managedNodesDirectory;
    }

    public String getEventServerNodeLabel() {
        return this.eventServerNodeLabel;
    }

    public void setEventServerNodeLabel(String eventServerNodeLabel) {
        this.eventServerNodeLabel = eventServerNodeLabel;
    }

    public NodesDirectoryDeployerMode getNodesDirectoryDeployerMode() {
        return this.nodesDirectoryDeployerMode;
    }

    public void setNodesDirectoryDeployerMode(NodesDirectoryDeployerMode nodesDirectoryDeployerMode) {
        this.nodesDirectoryDeployerMode = nodesDirectoryDeployerMode;
    }

    public String getCloudTags() {
        return this.cloudTags;
    }

    public void setCloudTags(String cloudTags) {
        this.cloudTags = cloudTags;
    }

    public CloudTagList getInheritedCloudTags(FMSettings settings) {
        CloudAccount ca = Objects.requireNonNullElse(this.cloudAccount, this.tenant.getVirtualCloudAccount(settings));
        return ca.getInheritedCloudTags().with(CloudTagList.fromJSON(ca.getCloudTags()));
    }

    public CloudTagList getCloudApplicableTags(FMSettings settings) {
        CloudAccount ca = Objects.requireNonNullElse(this.cloudAccount, this.tenant.getVirtualCloudAccount(settings));
        return ca.getCloudApplicableTags().with(CloudTagList.fromJSON(this.getCloudTags())).with("fm:virtualNetworkId", this.getId());
    }

    public static enum DNSStrategy {
        NONE,
        FM_MANAGED_CLOUD_DNS_SERVICE,
        VN_SPECIFIC_CLOUD_DNS_SERVICE;

    }

    public static enum HTTPSStrategy {
        NONE,
        SELF_SIGNED,
        CUSTOM_CERTIFICATE,
        LETSENCRYPT,
        AWS_ACM_PCA;

    }

    public static enum HTTPStrategy {
        DISABLE,
        REDIRECT;

    }

    public static enum NodesDirectoryDeployerMode {
        NO_MANAGED_DEPLOYER,
        CENTRAL_DEPLOYER,
        EACH_DESIGN_NODE;

    }

    public static enum VirtualNetworkMode {
        EXISTING_MONOTENANT,
        EXISTING_MULTITENANT_PUBLIC_IP,
        FM_MANAGED;

    }

    public static enum PeeringState {
        INTERNAL,
        EXTERNAL,
        NONE;

    }
}

