/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.alerts;

import com.dataiku.fm.model.db.CheckType;
import com.dataiku.fm.model.db.MessagingChannelType;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public class AlertingUtils {
    private static Map<MessagingChannelType, Integer> MESSAGING_CHANNEL_CONFIGURATION_DEFAULT_VERSIONS = Map.of(MessagingChannelType.SMTP, 1);
    private static Map<MessagingChannelType, Integer> CHECK_REPORTER_CONFIGURATION_DEFAULT_VERSIONS = Map.of(MessagingChannelType.SMTP, 1);
    private static Map<CheckType, Integer> CHECK_DEFINITION_CONFIGURATION_DEFAULT_VERSIONS = Map.of(CheckType.LOGICAL_INSTANCE_OS_DISK_CONSUMPTION, 1, CheckType.LOGICAL_INSTANCE_DATA_DISK_CONSUMPTION, 1, CheckType.LOGICAL_INSTANCE_INVALID_STATUS, 1);

    private AlertingUtils() {
    }

    public static int getMessagingChannelConfigurationDefaultVersion(MessagingChannelType type) {
        return MESSAGING_CHANNEL_CONFIGURATION_DEFAULT_VERSIONS.getOrDefault((Object)type, 1);
    }

    public static int getCheckReporterConfigurationDefaultVersion(MessagingChannelType type) {
        return CHECK_REPORTER_CONFIGURATION_DEFAULT_VERSIONS.getOrDefault((Object)type, 1);
    }

    public static int getCheckDefinitionConfigurationDefaultVersion(CheckType type) {
        return CHECK_DEFINITION_CONFIGURATION_DEFAULT_VERSIONS.getOrDefault((Object)type, 1);
    }

    public static String toPrintedTimestamp(long timestamp) {
        Instant instant = Instant.ofEpochMilli(timestamp);
        ZonedDateTime dateTime = instant.atZone(ZoneId.systemDefault());
        return dateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }
}

