/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.alerts;

import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.model.db.MessagingChannelType;
import com.dataiku.fm.server.alerts.CheckReporterService;
import com.dataiku.fm.server.alerts.senders.NotificationSender;
import com.dataiku.fm.server.alerts.senders.SMTPV1Sender;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessagingChannelService {
    Map<SenderKey, NotificationSender> senderMap;

    @Autowired
    public MessagingChannelService(CheckReporterService checkReporterService, CloudCryptoService cloudCryptoService) {
        this.senderMap = MessagingChannelService.buildMapKeyedByMessagingChannelType(Set.of(new SMTPV1Sender(checkReporterService, cloudCryptoService)));
    }

    public NotificationSender getNotificationSender(MessagingChannelType messagingChannelType, int configurationVersion) {
        return this.senderMap.get(new SenderKey(messagingChannelType, configurationVersion));
    }

    private static Map<SenderKey, NotificationSender> buildMapKeyedByMessagingChannelType(Set<NotificationSender> sendersSet) {
        return sendersSet.stream().collect(Collectors.toMap(sender -> new SenderKey(sender.getMessagingChannelType(), sender.getVersion()), Function.identity()));
    }

    record SenderKey(MessagingChannelType messagingChannelType, int integer) {
    }
}

