/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.core;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.SSOSettings;
import com.dataiku.dip.security.auth.AuthSyncSettings;
import com.dataiku.dip.security.auth.UserAttributes;
import com.dataiku.dip.security.auth.UserIdentity;
import com.dataiku.dip.security.azure.AzureADSettings;
import com.dataiku.dip.security.ldap.LdapSettings;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.LdapTestService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.Issuer;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.op.OIDCProviderConfigurationRequest;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.security.sso.FMSSOService;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMUIAuthService;
import com.dataiku.fm.server.security.auth.FMAzureADUserSupplier;
import com.dataiku.fm.server.settings.SettingsDAO;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class SecurityController
extends DIPInternalControllerBase {
    @Autowired
    private FMUIAuthService uiAuthService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private SettingsDAO settingsDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FMSSOService ssoAssistants;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    @Autowired
    private LdapTestService ldapTestService;

    @RequestMapping(value={"/api/ui/security/settings"})
    public void getSettings(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        SecuritySettings securitySettings = new SecuritySettings();
        FMSettings fmSettings = FMApp.getFMSettingsUnsafe();
        securitySettings.ssoSettings = fmSettings.ssoSettings;
        securitySettings.ldapSettings = fmSettings.ldapSettings;
        securitySettings.azureADSettings = fmSettings.azureADSettings;
        securitySettings.authSyncSettings = fmSettings.authSyncSettings;
        SecurityController.writeJSON((HttpServletResponse)resp, (Object)securitySettings);
    }

    @RequestMapping(value={"/api/ui/security/settings"}, method={RequestMethod.PUT})
    public void saveSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam(name="securitySettings") String securitySettings) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        SecuritySettings settings = (SecuritySettings)JSON.parse((String)securitySettings, SecuritySettings.class);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
            FMSettings fmSettings = this.settingsDAO.read();
            fmSettings.ssoSettings = settings.ssoSettings;
            fmSettings.ldapSettings = settings.ldapSettings;
            fmSettings.azureADSettings = settings.azureADSettings;
            fmSettings.authSyncSettings = settings.authSyncSettings;
            this.settingsDAO.save(fmSettings);
            t.commit("Save settings.json");
        }
        this.ssoAssistants.applySettings();
        SecurityController.writeJSON((HttpServletResponse)resp, (Object)settings);
    }

    @RequestMapping(value={"/api/ui/security/test-ldap-settings"})
    public void testLdapSettings(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
            this.permissionsService.checkOwnTenantAdmin(authCtx);
            LdapSettings settings = (LdapSettings)JSON.parse((String)data, LdapSettings.class);
            SecurityController.writeJSON((HttpServletResponse)resp, (Object)this.ldapTestService.testSettings(settings));
        }
    }

    @RequestMapping(value={"/api/ui/security/test-ldap-get-user-details"})
    public void testLdapGetUserDetails(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
            this.permissionsService.checkOwnTenantAdmin(authCtx);
            LdapTestService.LdapRequest ldapRequest = (LdapTestService.LdapRequest)JSON.parse((String)data, LdapTestService.LdapRequest.class);
            SecurityController.writeJSON((HttpServletResponse)resp, (Object)this.ldapTestService.getUserDetails(ldapRequest));
        }
    }

    @RequestMapping(value={"/api/ui/security/test-azure-ad-settings"})
    public void testAzureADSettings(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
            this.permissionsService.checkOwnTenantAdmin(authCtx);
            TestAzureADSettings testAzureADSettings = (TestAzureADSettings)JSON.parse((String)data, TestAzureADSettings.class);
            FMAzureADUserSupplier dssAzureADUserSupplier = new FMAzureADUserSupplier(this.passwordEncryptionService, testAzureADSettings.azureADSettings);
            UserAttributes userAttributes = dssAzureADUserSupplier.getUserAttributes(testAzureADSettings.userIdentity);
            SecurityController.writeJSON((HttpServletResponse)resp, (Object)new AzureADTestSettingsResult(userAttributes));
        }
        catch (Exception e) {
            logger.info((Object)"Testing Azure AD failed", (Throwable)e);
            SecurityController.writeJSON((HttpServletResponse)resp, (Object)new AzureADTestSettingsResult(new SerializedError((Throwable)e, false)));
        }
    }

    @AuditedCall(value={"msgType", "fetch-openid-config"})
    @RequestMapping(value={"/api/ui/sso/fetch-openid-config"})
    public void fetchOpenIDConfig(HttpServletRequest req, HttpServletResponse resp, String wellKnownURL) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        OIDCProviderConfigurationRequest request = new OIDCProviderConfigurationRequest(new Issuer(wellKnownURL.replace("/.well-known/openid-configuration", "")));
        HTTPRequest httpRequest = request.toHTTPRequest();
        ProxyUtils.applyProxySettings((ProxySettings)FMApp.getFMSettingsUnsafe().proxySettings, (HTTPRequest)httpRequest);
        HTTPResponse httpResponse = httpRequest.send();
        resp.setStatus(httpResponse.getStatusCode());
        SecurityController.writeJSONString((HttpServletResponse)resp, (String)httpResponse.getContent());
    }

    public static class SecuritySettings {
        public SSOSettings ssoSettings;
        public LdapSettings ldapSettings;
        public AzureADSettings azureADSettings;
        public AuthSyncSettings authSyncSettings;
    }

    public static class TestAzureADSettings {
        public AzureADSettings azureADSettings;
        public UserIdentity userIdentity;
    }

    public static class AzureADTestSettingsResult {
        public boolean connectionOK;
        public SerializedError connectionError;
        public UserAttributes userAttributes;

        public AzureADTestSettingsResult(UserAttributes userAttributes) {
            this.connectionOK = true;
            this.userAttributes = userAttributes;
        }

        public AzureADTestSettingsResult(SerializedError connectionError) {
            this.connectionOK = false;
            this.connectionError = connectionError;
        }
    }
}

