/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.notifications;

import com.dataiku.dip.DKUApp;
import com.dataiku.fm.model.db.CheckReporter;
import com.dataiku.fm.model.db.ElementCheck;
import com.dataiku.fm.model.db.MessagingChannel;
import com.dataiku.fm.server.alerts.MessagingChannelService;
import com.dataiku.fm.server.alerts.senders.NotificationSender;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotificationService {
    private static final int MAX_NUMBER_OF_PARALLEL_THREADS_DEFAULT = 10;
    private static final int MAX_NUMBER_OF_QUEUED_NOTIFICATIONS_DEFAULT = 2000;
    @Autowired
    private MessagingChannelService messagingChannelService;
    private ExecutorService executorService;

    @PostConstruct
    private void init() {
        int maxNumberOfParallelThreads = DKUApp.getProperty((String)"dku.fm.alerting.notifications.maxNumberOfParallelThreads", (int)10);
        int maxNumberOfQueuedNotifications = DKUApp.getProperty((String)"dku.fm.alerting.notifications.maxNumberOfQueuedNotifications", (int)2000);
        this.executorService = new ThreadPoolExecutor(maxNumberOfParallelThreads, maxNumberOfParallelThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxNumberOfQueuedNotifications));
    }

    @PreDestroy
    private void finish() {
        this.executorService.shutdown();
    }

    public void sendNotification(@Nonnull MessagingChannel messagingChannel, @Nonnull CheckReporter checkReporter, @Nonnull ElementCheck elementCheck, @Nonnull NotificationStatus notificationType) throws Exception {
        NotificationSender notificationSender = this.messagingChannelService.getNotificationSender(messagingChannel.getType(), messagingChannel.getConfigurationVersion());
        notificationSender.sendNotification(this.executorService, messagingChannel, checkReporter, elementCheck, notificationType);
    }

    public static enum NotificationStatus {
        FAILURE,
        RESOLUTION;

    }
}

