/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;

public class TaskSchedulerService {
    private TaskScheduler scheduler;
    private List<ScheduledFuture<?>> jobs = new ArrayList();

    public TaskSchedulerService() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setThreadNamePrefix("FmPoolScheduler");
        scheduler.setPoolSize(1);
        scheduler.initialize();
        this.scheduler = scheduler;
    }

    public void addScheduledTask(Runnable task, TaskSchedulerPeriod period) {
        ScheduledFuture scheduledTask = this.scheduler.schedule(task, (Trigger)new CronTrigger(period.toCronString()));
        this.jobs.add(scheduledTask);
    }

    public static enum TaskSchedulerPeriod {
        HOUR("0 0 0/1 1/1 * ?"),
        MINUTE("0 0/1 * 1/1 * ?");

        private final String cronString;

        private TaskSchedulerPeriod(String cronString) {
            this.cronString = cronString;
        }

        public String toCronString() {
            return this.cronString;
        }
    }
}

