/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

public class PrettyString {
    public static boolean isInteractif() {
        return System.console() != null;
    }

    public static boolean displayWithColor() {
        return PrettyString.isInteractif() || System.getenv("CLICOLOR_FORCE") != null;
    }

    public static String quoted(Object msg) {
        return "\"" + msg.toString() + "\"";
    }

    public static String squoted(Object msg) {
        return "'" + msg.toString() + "'";
    }

    public static String pquoted(Object msg) {
        return "`" + msg.toString() + "'";
    }

    public static String nl(String ... msgs) {
        StringBuilder sb = new StringBuilder();
        for (String msg : msgs) {
            sb.append(msg);
            sb.append(PrettyString.eol());
        }
        return sb.toString();
    }

    public static String eol() {
        return System.getProperty("line.separator");
    }

    protected static String cat(String concatenateStr, Object ... msg) {
        StringBuilder b = new StringBuilder();
        if (msg.length > 0) {
            boolean first = true;
            for (int i = 0; i < msg.length; ++i) {
                String m = msg[i].toString();
                if (m.isEmpty()) continue;
                if (first) {
                    first = false;
                } else {
                    b.append(concatenateStr);
                }
                b.append(m);
            }
        }
        return b.toString();
    }

    public static String scat(Object ... msg) {
        return PrettyString.cat(" ", msg);
    }

    public static String nlcat(Object ... msg) {
        return PrettyString.cat(PrettyString.eol(), msg);
    }

    public static String format(String str, String color) {
        if (PrettyString.displayWithColor()) {
            return "\u001b[" + color + "m" + str + "\u001b[0m";
        }
        return str;
    }

    public static String red(String str) {
        return PrettyString.format(str, "31");
    }
}

