/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.cloudwatch.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.cloudwatch.model.MetricStreamFilter;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.cloudwatch.model.MetricStreamStatisticsConfiguration;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.cloudwatch.model.MetricStreamStatisticsMetric;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.cloudwatch.model.PutMetricStreamRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.cloudwatch.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class PutMetricStreamRequestMarshaller
implements Marshaller<Request<PutMetricStreamRequest>, PutMetricStreamRequest> {
    @Override
    public Request<PutMetricStreamRequest> marshall(PutMetricStreamRequest putMetricStreamRequest) {
        int metricNamesListIndex;
        SdkInternalList metricNamesList;
        if (putMetricStreamRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutMetricStreamRequest> request = new DefaultRequest<PutMetricStreamRequest>(putMetricStreamRequest, "AmazonCloudWatch");
        request.addParameter("Action", "PutMetricStream");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putMetricStreamRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString(putMetricStreamRequest.getName()));
        }
        if (!putMetricStreamRequest.getIncludeFilters().isEmpty() || !((SdkInternalList)putMetricStreamRequest.getIncludeFilters()).isAutoConstruct()) {
            SdkInternalList includeFiltersList = (SdkInternalList)putMetricStreamRequest.getIncludeFilters();
            int includeFiltersListIndex = 1;
            for (MetricStreamFilter includeFiltersListValue : includeFiltersList) {
                if (includeFiltersListValue != null) {
                    if (includeFiltersListValue.getNamespace() != null) {
                        request.addParameter("IncludeFilters.member." + includeFiltersListIndex + ".Namespace", StringUtils.fromString(includeFiltersListValue.getNamespace()));
                    }
                    if (!includeFiltersListValue.getMetricNames().isEmpty() || !((SdkInternalList)includeFiltersListValue.getMetricNames()).isAutoConstruct()) {
                        metricNamesList = (SdkInternalList)includeFiltersListValue.getMetricNames();
                        metricNamesListIndex = 1;
                        for (String metricNamesListValue : metricNamesList) {
                            if (metricNamesListValue != null) {
                                request.addParameter("IncludeFilters.member." + includeFiltersListIndex + ".MetricNames.member." + metricNamesListIndex, StringUtils.fromString(metricNamesListValue));
                            }
                            ++metricNamesListIndex;
                        }
                    }
                }
                ++includeFiltersListIndex;
            }
        }
        if (!putMetricStreamRequest.getExcludeFilters().isEmpty() || !((SdkInternalList)putMetricStreamRequest.getExcludeFilters()).isAutoConstruct()) {
            SdkInternalList excludeFiltersList = (SdkInternalList)putMetricStreamRequest.getExcludeFilters();
            int excludeFiltersListIndex = 1;
            for (MetricStreamFilter excludeFiltersListValue : excludeFiltersList) {
                if (excludeFiltersListValue != null) {
                    if (excludeFiltersListValue.getNamespace() != null) {
                        request.addParameter("ExcludeFilters.member." + excludeFiltersListIndex + ".Namespace", StringUtils.fromString(excludeFiltersListValue.getNamespace()));
                    }
                    if (!excludeFiltersListValue.getMetricNames().isEmpty() || !((SdkInternalList)excludeFiltersListValue.getMetricNames()).isAutoConstruct()) {
                        metricNamesList = (SdkInternalList)excludeFiltersListValue.getMetricNames();
                        metricNamesListIndex = 1;
                        for (String metricNamesListValue : metricNamesList) {
                            if (metricNamesListValue != null) {
                                request.addParameter("ExcludeFilters.member." + excludeFiltersListIndex + ".MetricNames.member." + metricNamesListIndex, StringUtils.fromString(metricNamesListValue));
                            }
                            ++metricNamesListIndex;
                        }
                    }
                }
                ++excludeFiltersListIndex;
            }
        }
        if (putMetricStreamRequest.getFirehoseArn() != null) {
            request.addParameter("FirehoseArn", StringUtils.fromString(putMetricStreamRequest.getFirehoseArn()));
        }
        if (putMetricStreamRequest.getRoleArn() != null) {
            request.addParameter("RoleArn", StringUtils.fromString(putMetricStreamRequest.getRoleArn()));
        }
        if (putMetricStreamRequest.getOutputFormat() != null) {
            request.addParameter("OutputFormat", StringUtils.fromString(putMetricStreamRequest.getOutputFormat()));
        }
        if (!putMetricStreamRequest.getTags().isEmpty() || !((SdkInternalList)putMetricStreamRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)putMetricStreamRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        if (!putMetricStreamRequest.getStatisticsConfigurations().isEmpty() || !((SdkInternalList)putMetricStreamRequest.getStatisticsConfigurations()).isAutoConstruct()) {
            SdkInternalList statisticsConfigurationsList = (SdkInternalList)putMetricStreamRequest.getStatisticsConfigurations();
            int statisticsConfigurationsListIndex = 1;
            for (MetricStreamStatisticsConfiguration statisticsConfigurationsListValue : statisticsConfigurationsList) {
                if (statisticsConfigurationsListValue != null) {
                    if (!statisticsConfigurationsListValue.getIncludeMetrics().isEmpty() || !((SdkInternalList)statisticsConfigurationsListValue.getIncludeMetrics()).isAutoConstruct()) {
                        SdkInternalList includeMetricsList = (SdkInternalList)statisticsConfigurationsListValue.getIncludeMetrics();
                        int includeMetricsListIndex = 1;
                        for (MetricStreamStatisticsMetric includeMetricsListValue : includeMetricsList) {
                            if (includeMetricsListValue != null) {
                                if (includeMetricsListValue.getNamespace() != null) {
                                    request.addParameter("StatisticsConfigurations.member." + statisticsConfigurationsListIndex + ".IncludeMetrics.member." + includeMetricsListIndex + ".Namespace", StringUtils.fromString(includeMetricsListValue.getNamespace()));
                                }
                                if (includeMetricsListValue.getMetricName() != null) {
                                    request.addParameter("StatisticsConfigurations.member." + statisticsConfigurationsListIndex + ".IncludeMetrics.member." + includeMetricsListIndex + ".MetricName", StringUtils.fromString(includeMetricsListValue.getMetricName()));
                                }
                            }
                            ++includeMetricsListIndex;
                        }
                    }
                    if (!statisticsConfigurationsListValue.getAdditionalStatistics().isEmpty() || !((SdkInternalList)statisticsConfigurationsListValue.getAdditionalStatistics()).isAutoConstruct()) {
                        SdkInternalList additionalStatisticsList = (SdkInternalList)statisticsConfigurationsListValue.getAdditionalStatistics();
                        int additionalStatisticsListIndex = 1;
                        for (String additionalStatisticsListValue : additionalStatisticsList) {
                            if (additionalStatisticsListValue != null) {
                                request.addParameter("StatisticsConfigurations.member." + statisticsConfigurationsListIndex + ".AdditionalStatistics.member." + additionalStatisticsListIndex, StringUtils.fromString(additionalStatisticsListValue));
                            }
                            ++additionalStatisticsListIndex;
                        }
                    }
                }
                ++statisticsConfigurationsListIndex;
            }
        }
        if (putMetricStreamRequest.getIncludeLinkedAccountsMetrics() != null) {
            request.addParameter("IncludeLinkedAccountsMetrics", StringUtils.fromBoolean(putMetricStreamRequest.getIncludeLinkedAccountsMetrics()));
        }
        return request;
    }
}

