/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CloudWatchLogOptionsSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.IKEVersionsRequestListValue;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ModifyVpnTunnelOptionsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ModifyVpnTunnelOptionsSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Phase1DHGroupNumbersRequestListValue;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Phase1EncryptionAlgorithmsRequestListValue;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Phase1IntegrityAlgorithmsRequestListValue;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Phase2DHGroupNumbersRequestListValue;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Phase2EncryptionAlgorithmsRequestListValue;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Phase2IntegrityAlgorithmsRequestListValue;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.VpnTunnelLogOptionsSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class ModifyVpnTunnelOptionsRequestMarshaller
implements Marshaller<Request<ModifyVpnTunnelOptionsRequest>, ModifyVpnTunnelOptionsRequest> {
    @Override
    public Request<ModifyVpnTunnelOptionsRequest> marshall(ModifyVpnTunnelOptionsRequest modifyVpnTunnelOptionsRequest) {
        ModifyVpnTunnelOptionsSpecification tunnelOptions;
        if (modifyVpnTunnelOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyVpnTunnelOptionsRequest> request = new DefaultRequest<ModifyVpnTunnelOptionsRequest>(modifyVpnTunnelOptionsRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVpnTunnelOptions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVpnTunnelOptionsRequest.getVpnConnectionId() != null) {
            request.addParameter("VpnConnectionId", StringUtils.fromString(modifyVpnTunnelOptionsRequest.getVpnConnectionId()));
        }
        if (modifyVpnTunnelOptionsRequest.getVpnTunnelOutsideIpAddress() != null) {
            request.addParameter("VpnTunnelOutsideIpAddress", StringUtils.fromString(modifyVpnTunnelOptionsRequest.getVpnTunnelOutsideIpAddress()));
        }
        if ((tunnelOptions = modifyVpnTunnelOptionsRequest.getTunnelOptions()) != null) {
            CloudWatchLogOptionsSpecification cloudWatchLogOptions;
            VpnTunnelLogOptionsSpecification logOptions;
            SdkInternalList modifyVpnTunnelOptionsSpecificationIKEVersionsList;
            SdkInternalList modifyVpnTunnelOptionsSpecificationPhase2DHGroupNumbersList;
            SdkInternalList modifyVpnTunnelOptionsSpecificationPhase1DHGroupNumbersList;
            SdkInternalList modifyVpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsList;
            SdkInternalList modifyVpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsList;
            SdkInternalList modifyVpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsList;
            SdkInternalList modifyVpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsList;
            if (tunnelOptions.getTunnelInsideCidr() != null) {
                request.addParameter("TunnelOptions.TunnelInsideCidr", StringUtils.fromString(tunnelOptions.getTunnelInsideCidr()));
            }
            if (tunnelOptions.getTunnelInsideIpv6Cidr() != null) {
                request.addParameter("TunnelOptions.TunnelInsideIpv6Cidr", StringUtils.fromString(tunnelOptions.getTunnelInsideIpv6Cidr()));
            }
            if (tunnelOptions.getPreSharedKey() != null) {
                request.addParameter("TunnelOptions.PreSharedKey", StringUtils.fromString(tunnelOptions.getPreSharedKey()));
            }
            if (tunnelOptions.getPhase1LifetimeSeconds() != null) {
                request.addParameter("TunnelOptions.Phase1LifetimeSeconds", StringUtils.fromInteger(tunnelOptions.getPhase1LifetimeSeconds()));
            }
            if (tunnelOptions.getPhase2LifetimeSeconds() != null) {
                request.addParameter("TunnelOptions.Phase2LifetimeSeconds", StringUtils.fromInteger(tunnelOptions.getPhase2LifetimeSeconds()));
            }
            if (tunnelOptions.getRekeyMarginTimeSeconds() != null) {
                request.addParameter("TunnelOptions.RekeyMarginTimeSeconds", StringUtils.fromInteger(tunnelOptions.getRekeyMarginTimeSeconds()));
            }
            if (tunnelOptions.getRekeyFuzzPercentage() != null) {
                request.addParameter("TunnelOptions.RekeyFuzzPercentage", StringUtils.fromInteger(tunnelOptions.getRekeyFuzzPercentage()));
            }
            if (tunnelOptions.getReplayWindowSize() != null) {
                request.addParameter("TunnelOptions.ReplayWindowSize", StringUtils.fromInteger(tunnelOptions.getReplayWindowSize()));
            }
            if (tunnelOptions.getDPDTimeoutSeconds() != null) {
                request.addParameter("TunnelOptions.DPDTimeoutSeconds", StringUtils.fromInteger(tunnelOptions.getDPDTimeoutSeconds()));
            }
            if (tunnelOptions.getDPDTimeoutAction() != null) {
                request.addParameter("TunnelOptions.DPDTimeoutAction", StringUtils.fromString(tunnelOptions.getDPDTimeoutAction()));
            }
            if (!(modifyVpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsList = (SdkInternalList)tunnelOptions.getPhase1EncryptionAlgorithms()).isEmpty() || !modifyVpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsList.isAutoConstruct()) {
                int phase1EncryptionAlgorithmsListIndex = 1;
                for (Object modifyVpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsListValue : modifyVpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsList) {
                    if (((Phase1EncryptionAlgorithmsRequestListValue)modifyVpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsListValue).getValue() != null) {
                        request.addParameter("TunnelOptions.Phase1EncryptionAlgorithm." + phase1EncryptionAlgorithmsListIndex + ".Value", StringUtils.fromString(((Phase1EncryptionAlgorithmsRequestListValue)modifyVpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsListValue).getValue()));
                    }
                    ++phase1EncryptionAlgorithmsListIndex;
                }
            }
            if (!(modifyVpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsList = (SdkInternalList)tunnelOptions.getPhase2EncryptionAlgorithms()).isEmpty() || !modifyVpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsList.isAutoConstruct()) {
                int phase2EncryptionAlgorithmsListIndex = 1;
                for (Object modifyVpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsListValue : modifyVpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsList) {
                    if (((Phase2EncryptionAlgorithmsRequestListValue)modifyVpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsListValue).getValue() != null) {
                        request.addParameter("TunnelOptions.Phase2EncryptionAlgorithm." + phase2EncryptionAlgorithmsListIndex + ".Value", StringUtils.fromString(((Phase2EncryptionAlgorithmsRequestListValue)modifyVpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsListValue).getValue()));
                    }
                    ++phase2EncryptionAlgorithmsListIndex;
                }
            }
            if (!(modifyVpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsList = (SdkInternalList)tunnelOptions.getPhase1IntegrityAlgorithms()).isEmpty() || !modifyVpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsList.isAutoConstruct()) {
                int phase1IntegrityAlgorithmsListIndex = 1;
                for (Object modifyVpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsListValue : modifyVpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsList) {
                    if (((Phase1IntegrityAlgorithmsRequestListValue)modifyVpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsListValue).getValue() != null) {
                        request.addParameter("TunnelOptions.Phase1IntegrityAlgorithm." + phase1IntegrityAlgorithmsListIndex + ".Value", StringUtils.fromString(((Phase1IntegrityAlgorithmsRequestListValue)modifyVpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsListValue).getValue()));
                    }
                    ++phase1IntegrityAlgorithmsListIndex;
                }
            }
            if (!(modifyVpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsList = (SdkInternalList)tunnelOptions.getPhase2IntegrityAlgorithms()).isEmpty() || !modifyVpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsList.isAutoConstruct()) {
                int phase2IntegrityAlgorithmsListIndex = 1;
                for (Object modifyVpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsListValue : modifyVpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsList) {
                    if (((Phase2IntegrityAlgorithmsRequestListValue)modifyVpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsListValue).getValue() != null) {
                        request.addParameter("TunnelOptions.Phase2IntegrityAlgorithm." + phase2IntegrityAlgorithmsListIndex + ".Value", StringUtils.fromString(((Phase2IntegrityAlgorithmsRequestListValue)modifyVpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsListValue).getValue()));
                    }
                    ++phase2IntegrityAlgorithmsListIndex;
                }
            }
            if (!(modifyVpnTunnelOptionsSpecificationPhase1DHGroupNumbersList = (SdkInternalList)tunnelOptions.getPhase1DHGroupNumbers()).isEmpty() || !modifyVpnTunnelOptionsSpecificationPhase1DHGroupNumbersList.isAutoConstruct()) {
                int phase1DHGroupNumbersListIndex = 1;
                for (Object modifyVpnTunnelOptionsSpecificationPhase1DHGroupNumbersListValue : modifyVpnTunnelOptionsSpecificationPhase1DHGroupNumbersList) {
                    if (((Phase1DHGroupNumbersRequestListValue)modifyVpnTunnelOptionsSpecificationPhase1DHGroupNumbersListValue).getValue() != null) {
                        request.addParameter("TunnelOptions.Phase1DHGroupNumber." + phase1DHGroupNumbersListIndex + ".Value", StringUtils.fromInteger(((Phase1DHGroupNumbersRequestListValue)modifyVpnTunnelOptionsSpecificationPhase1DHGroupNumbersListValue).getValue()));
                    }
                    ++phase1DHGroupNumbersListIndex;
                }
            }
            if (!(modifyVpnTunnelOptionsSpecificationPhase2DHGroupNumbersList = (SdkInternalList)tunnelOptions.getPhase2DHGroupNumbers()).isEmpty() || !modifyVpnTunnelOptionsSpecificationPhase2DHGroupNumbersList.isAutoConstruct()) {
                int phase2DHGroupNumbersListIndex = 1;
                for (Object modifyVpnTunnelOptionsSpecificationPhase2DHGroupNumbersListValue : modifyVpnTunnelOptionsSpecificationPhase2DHGroupNumbersList) {
                    if (((Phase2DHGroupNumbersRequestListValue)modifyVpnTunnelOptionsSpecificationPhase2DHGroupNumbersListValue).getValue() != null) {
                        request.addParameter("TunnelOptions.Phase2DHGroupNumber." + phase2DHGroupNumbersListIndex + ".Value", StringUtils.fromInteger(((Phase2DHGroupNumbersRequestListValue)modifyVpnTunnelOptionsSpecificationPhase2DHGroupNumbersListValue).getValue()));
                    }
                    ++phase2DHGroupNumbersListIndex;
                }
            }
            if (!(modifyVpnTunnelOptionsSpecificationIKEVersionsList = (SdkInternalList)tunnelOptions.getIKEVersions()).isEmpty() || !modifyVpnTunnelOptionsSpecificationIKEVersionsList.isAutoConstruct()) {
                int iKEVersionsListIndex = 1;
                for (IKEVersionsRequestListValue modifyVpnTunnelOptionsSpecificationIKEVersionsListValue : modifyVpnTunnelOptionsSpecificationIKEVersionsList) {
                    if (modifyVpnTunnelOptionsSpecificationIKEVersionsListValue.getValue() != null) {
                        request.addParameter("TunnelOptions.IKEVersion." + iKEVersionsListIndex + ".Value", StringUtils.fromString(modifyVpnTunnelOptionsSpecificationIKEVersionsListValue.getValue()));
                    }
                    ++iKEVersionsListIndex;
                }
            }
            if (tunnelOptions.getStartupAction() != null) {
                request.addParameter("TunnelOptions.StartupAction", StringUtils.fromString(tunnelOptions.getStartupAction()));
            }
            if ((logOptions = tunnelOptions.getLogOptions()) != null && (cloudWatchLogOptions = logOptions.getCloudWatchLogOptions()) != null) {
                if (cloudWatchLogOptions.getLogEnabled() != null) {
                    request.addParameter("TunnelOptions.LogOptions.CloudWatchLogOptions.LogEnabled", StringUtils.fromBoolean(cloudWatchLogOptions.getLogEnabled()));
                }
                if (cloudWatchLogOptions.getLogGroupArn() != null) {
                    request.addParameter("TunnelOptions.LogOptions.CloudWatchLogOptions.LogGroupArn", StringUtils.fromString(cloudWatchLogOptions.getLogGroupArn()));
                }
                if (cloudWatchLogOptions.getLogOutputFormat() != null) {
                    request.addParameter("TunnelOptions.LogOptions.CloudWatchLogOptions.LogOutputFormat", StringUtils.fromString(cloudWatchLogOptions.getLogOutputFormat()));
                }
            }
            if (tunnelOptions.getEnableTunnelLifecycleControl() != null) {
                request.addParameter("TunnelOptions.EnableTunnelLifecycleControl", StringUtils.fromBoolean(tunnelOptions.getEnableTunnelLifecycleControl()));
            }
        }
        if (modifyVpnTunnelOptionsRequest.getSkipTunnelReplacement() != null) {
            request.addParameter("SkipTunnelReplacement", StringUtils.fromBoolean(modifyVpnTunnelOptionsRequest.getSkipTunnelReplacement()));
        }
        return request;
    }
}

