/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.CreateTargetGroupRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.Matcher;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateTargetGroupRequestMarshaller
implements Marshaller<Request<CreateTargetGroupRequest>, CreateTargetGroupRequest> {
    @Override
    public Request<CreateTargetGroupRequest> marshall(CreateTargetGroupRequest createTargetGroupRequest) {
        Matcher matcher;
        if (createTargetGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateTargetGroupRequest> request = new DefaultRequest<CreateTargetGroupRequest>(createTargetGroupRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "CreateTargetGroup");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createTargetGroupRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString(createTargetGroupRequest.getName()));
        }
        if (createTargetGroupRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString(createTargetGroupRequest.getProtocol()));
        }
        if (createTargetGroupRequest.getProtocolVersion() != null) {
            request.addParameter("ProtocolVersion", StringUtils.fromString(createTargetGroupRequest.getProtocolVersion()));
        }
        if (createTargetGroupRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger(createTargetGroupRequest.getPort()));
        }
        if (createTargetGroupRequest.getVpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString(createTargetGroupRequest.getVpcId()));
        }
        if (createTargetGroupRequest.getHealthCheckProtocol() != null) {
            request.addParameter("HealthCheckProtocol", StringUtils.fromString(createTargetGroupRequest.getHealthCheckProtocol()));
        }
        if (createTargetGroupRequest.getHealthCheckPort() != null) {
            request.addParameter("HealthCheckPort", StringUtils.fromString(createTargetGroupRequest.getHealthCheckPort()));
        }
        if (createTargetGroupRequest.getHealthCheckEnabled() != null) {
            request.addParameter("HealthCheckEnabled", StringUtils.fromBoolean(createTargetGroupRequest.getHealthCheckEnabled()));
        }
        if (createTargetGroupRequest.getHealthCheckPath() != null) {
            request.addParameter("HealthCheckPath", StringUtils.fromString(createTargetGroupRequest.getHealthCheckPath()));
        }
        if (createTargetGroupRequest.getHealthCheckIntervalSeconds() != null) {
            request.addParameter("HealthCheckIntervalSeconds", StringUtils.fromInteger(createTargetGroupRequest.getHealthCheckIntervalSeconds()));
        }
        if (createTargetGroupRequest.getHealthCheckTimeoutSeconds() != null) {
            request.addParameter("HealthCheckTimeoutSeconds", StringUtils.fromInteger(createTargetGroupRequest.getHealthCheckTimeoutSeconds()));
        }
        if (createTargetGroupRequest.getHealthyThresholdCount() != null) {
            request.addParameter("HealthyThresholdCount", StringUtils.fromInteger(createTargetGroupRequest.getHealthyThresholdCount()));
        }
        if (createTargetGroupRequest.getUnhealthyThresholdCount() != null) {
            request.addParameter("UnhealthyThresholdCount", StringUtils.fromInteger(createTargetGroupRequest.getUnhealthyThresholdCount()));
        }
        if ((matcher = createTargetGroupRequest.getMatcher()) != null) {
            if (matcher.getHttpCode() != null) {
                request.addParameter("Matcher.HttpCode", StringUtils.fromString(matcher.getHttpCode()));
            }
            if (matcher.getGrpcCode() != null) {
                request.addParameter("Matcher.GrpcCode", StringUtils.fromString(matcher.getGrpcCode()));
            }
        }
        if (createTargetGroupRequest.getTargetType() != null) {
            request.addParameter("TargetType", StringUtils.fromString(createTargetGroupRequest.getTargetType()));
        }
        if (createTargetGroupRequest.getTags() != null) {
            List<Tag> tagsList = createTargetGroupRequest.getTags();
            if (tagsList.isEmpty()) {
                request.addParameter("Tags", "");
            } else {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue != null) {
                        if (tagsListValue.getKey() != null) {
                            request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                        }
                        if (tagsListValue.getValue() != null) {
                            request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                        }
                    }
                    ++tagsListIndex;
                }
            }
        }
        if (createTargetGroupRequest.getIpAddressType() != null) {
            request.addParameter("IpAddressType", StringUtils.fromString(createTargetGroupRequest.getIpAddressType()));
        }
        return request;
    }
}

