/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.simpleemail.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.simpleemail.model.Template;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.simpleemail.model.UpdateTemplateRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class UpdateTemplateRequestMarshaller
implements Marshaller<Request<UpdateTemplateRequest>, UpdateTemplateRequest> {
    @Override
    public Request<UpdateTemplateRequest> marshall(UpdateTemplateRequest updateTemplateRequest) {
        if (updateTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateTemplateRequest> request = new DefaultRequest<UpdateTemplateRequest>(updateTemplateRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "UpdateTemplate");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        Template template = updateTemplateRequest.getTemplate();
        if (template != null) {
            if (template.getTemplateName() != null) {
                request.addParameter("Template.TemplateName", StringUtils.fromString(template.getTemplateName()));
            }
            if (template.getSubjectPart() != null) {
                request.addParameter("Template.SubjectPart", StringUtils.fromString(template.getSubjectPart()));
            }
            if (template.getTextPart() != null) {
                request.addParameter("Template.TextPart", StringUtils.fromString(template.getTextPart()));
            }
            if (template.getHtmlPart() != null) {
                request.addParameter("Template.HtmlPart", StringUtils.fromString(template.getHtmlPart()));
            }
        }
        return request;
    }
}

