(function(){
    'use strict';

    const requestPlugin = {
        bindings: {
            request: '<',
            requester: '<',
            closer: '<',
            onChange: '&',
            pluginObjectLink: '<'
        },
        templateUrl: '/static/dataiku/inbox/components/request-center/request/request-plugin/request-plugin.component.html',
        controller: function(){
            this.callback = () => {
                const response = {type: 'PluginResponse'}; // keep type in sync with backend
                this.onChange({response});
            }
            this.$onInit = () => {
                this.callback();
            }

            this.getRequestTypeLabel = function(){
                return this.request.requestType === "UPDATE_PLUGIN" ? "update" : "installation";
            }
        }
    }

    angular.module('dataiku.inbox')
    .component('requestPlugin', requestPlugin);
})();
