(function() {
    'use strict';

    angular.module('dataiku.dashboards').component('dashboardGridBackground', {
        bindings: {
            columnNumber: '<', // number
            backgroundColor: '<', // string
            gridColor: '<', // string
            tileSpacing: '<', // number
            cellWidth: '<', // number
            cellHeight: '<' // number
        },
        templateUrl: '/static/dataiku/js/dashboards/components/dashboard-grid-background/dashboard-grid-background.component.html',
        controller: function() {
            const ctrl = this;

            ctrl.$onChanges = function() {
                ctrl.styles = getGridStyle();
            };

            function getGridStyle() {
                const tileMargin = ctrl.tileSpacing / 2;
                if (ctrl.cellWidth != null && ctrl.cellHeight != null && tileMargin != null) {
                    return {
                        width: (ctrl.columnNumber * ctrl.cellWidth) + 'px',
                        height: '100%',
                        backgroundColor: ctrl.backgroundColor,
                        backgroundSize: `${ctrl.cellWidth}px ${ctrl.cellHeight}px`,
                        backgroundImage: `linear-gradient(to right, ${ctrl.gridColor} calc(2 * ${tileMargin}px), transparent 1px),
                            linear-gradient(to bottom, ${ctrl.gridColor} calc(2 * ${tileMargin}px), transparent 1px)`
                    };
                }
            };
        }
    });
})();
