(function () {
    'use strict';

    angular
        .module('dataiku.charts')
        .component('dashboardPageMenu', {
            templateUrl: '/static/dataiku/js/simple_report/components/dashboard-page-menu/dashboard-page-menu.component.html',
            bindings: {
                canEdit: '<',
                urlToCopy: '<',
                onDuplicate: '&',
                onEdit: '&',
                onRemove: '&',
            },
            controller: function (DashboardUtils) {
                const ctrl = this;
                ctrl.copyURL = () => {
                    DashboardUtils.copyToClipboard(ctrl.urlToCopy);
                }
            }
        });
})();
