(function() {
    'use strict';

    /**
     * <text-align-subform value="value"></text-align-subform>
     *
     * @param { 'LEFT' | 'RIGHT' | 'CENTER'}    value
     */
    angular.module('dataiku.charts').component('textAlignSubform', {
        templateUrl: '/static/dataiku/js/simple_report/components/text-align-subform/text-align-subform.component.html',
        bindings: {
            value: '='
        },
        controller: function($timeout, translate) {
            const ctrl = this;

            this.translate = translate;

            ctrl.setAlignment = (alignment) => {
                $timeout(() => ctrl.value = alignment);
            };
        }
    });
})();
