(function() {
    "use strict";

    const rightColScheduleButton = { // right-col-schedule-button
        bindings: {
            label: '@',
            title: '@',
            objectType: '@',
            selectedObjects: '<',
            disabled: '<',
        },
        templateUrl: 'static/dataiku/schedule-scenario/schedule-scenario-button/right-col-schedule-button.component.html',
        controller: function($element, $scope, $rootScope, AnyLoc, CreateModalFromTemplate, Dialogs, DataikuAPI) {
            const ctrl = this;
            ctrl.schedule = function() {
                const temporalTrigger = $rootScope.appConfig.licensedFeatures.temporalTriggerAllowed || $rootScope.appConfig.licensing.ceEntrepriseTrial;
                if (!temporalTrigger) {
                    Dialogs.eeUnavailableFeature($scope,
                        "This kind of trigger is not enabled in your Dataiku DSS license",
                        "https://doc.dataiku.com/dss/latest/scenarios/definitions.html#triggers");
                    return;
                }
                CreateModalFromTemplate("/static/dataiku/schedule-scenario/schedule-scenario-modal/schedule-scenario-modal.html", $scope, null, function(modalScope) {

                    if(ctrl.objectType === 'RECIPE'){
                        DataikuAPI.flow.recipes.getFullInfo(ctrl.selectedObjects[0].projectKey, ctrl.selectedObjects[0].name).success(function(data){
                            modalScope.selectedObjects = Object.values(data.outputs);
                            modalScope.objectType = modalScope.selectedObjects.length > 1 ? 'MULTIPLE' : modalScope.selectedObjects[0].objectType

                            modalScope.initModal();
                        }).error(setErrorInScope.bind($scope));
                    } else {
                        modalScope.selectedObjects = ctrl.selectedObjects;
                        modalScope.objectType = ctrl.objectType;

                        modalScope.initModal();
                    }
                });
            }


        }
    }


    angular.module("dataiku.scheduleScenario").component("rightColScheduleButton", rightColScheduleButton);
})();