/* global describe, it, xit, beforeEach, ChartFeaturesTestUtils */

describe('chart features treemap', function () {

    const chartType = 'treemap';
    const chartVariant = 'normal';

    /* Get tests helpers */
    const { expectIdToBeVisible, expectIdToBeHidden, renderTemplate } = ChartFeaturesTestUtils;

    /* Initialize each test */
    beforeEach(() => {
        ChartFeaturesTestUtils.initEachTest();
        ChartFeaturesTestUtils.initChartType(chartType, chartVariant);
    });

    it('has left menu filters dropzone', function () {
        ChartFeaturesTestUtils.setYDimensionFromAlphanumericalColumns();
        ChartFeaturesTestUtils.setXYGenericFromNumericalColumns();
        ChartFeaturesTestUtils.initDiscreteLegends();
        renderTemplate('/templates/simple_report/left-column/left-column.html');

        //filter
        expectIdToBeVisible('qa_charts_filter-submenu-header');
        expectIdToBeVisible('qa_charts_filters-dropzone');

        //legend
        expectIdToBeVisible('qa_charts_legends-submenu-header');
    });

    it('does not have left menu dimensions options', function () {
        renderTemplate('/templates/simple_report/left-column/dimensions.html');

        expectIdToBeVisible('qa_charts_tooltip-submenu-header');
        expectIdToBeHidden('qa_charts_animation-submenu-header');
        expectIdToBeHidden('qa_charts_animation-dropzone');
        expectIdToBeHidden('qa_charts_subchart-submenu-header');
        expectIdToBeHidden('qa_charts_subcharts-dropzone');
    });

    it('has group, size and color options', function() {
        ChartFeaturesTestUtils.setYDimensionFromAlphanumericalColumns();
        ChartFeaturesTestUtils.setGenericMeasureFromNumericalColumns();
        ChartFeaturesTestUtils.setColorMeasureFromNumericalColumns();
        ChartFeaturesTestUtils.mockIsAlphanumLikeDimension();
        renderTemplate(`/templates/simple_report/types/definition-${chartType}.html`);

        //group dimension
        $('.measure-wrapper')[0].click();
        expectIdToBeHidden('qa_charts_binning-select');
        expectIdToBeHidden('dimension_nb_bins_input');
        expectIdToBeHidden('qa_charts_adjust-binning-for-nice-bounds');
        expectIdToBeHidden('qa_charts_handling-empty-bins-select');
        expectIdToBeHidden('dimension_bin_size_input');
        expectIdToBeHidden('qa_charts_date-ranges-options-select');
        expectIdToBeVisible('qa_charts_sorting-select');
        expectIdToBeVisible('max_displayed_values_input');
        expectIdToBeVisible('qa_charts_group-others-input');
        expectIdToBeHidden('qa_charts_one-tick-per-bin-select');
        expectIdToBeHidden('qa_charts_dropdown-format-button');

        //size measure
        $('.measure-wrapper')[1].click();
        expectIdToBeVisible('qa_charts_aggregation-type-select');
        expectIdToBeVisible('qa_charts_computation-type-select');
        expectIdToBeHidden('qa_charts_along-dimension-select');
        expectIdToBeHidden('qa_charts_multi-y-axis-select');
        expectIdToBeHidden('qa_charts_multiplot-mode-select');
        expectIdToBeVisible('qa_charts_display-label');
    });

    it('doesn\'t have along dimension option with compute mode NORMAL', function () {
        ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'NORMAL', false);
    })

    it('has along dimension option with compute mode PERCENTAGE', function () {
        ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'PERCENTAGE');
    })

    it('has along dimension option with compute mode CUMULATIVE_PERCENTAGE', function () {
        ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'CUMULATIVE_PERCENTAGE');
    })

    it('doesn\'t have along dimension option with compute mode CUMULATIVE', function () {
        ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'CUMULATIVE', false);
    })

    it('has along dimension option with compute mode AVG_RATIO', function () {
        ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'AVG_RATIO');
    })

    it('doesn\'t have regression line options', function () {
        renderTemplate(`/templates/simple_report/types/options-${chartType}.html`);
        expectIdToBeHidden('qa_charts_regression-line-form');
    })

});

