import logging

import pandas as pd

from dataiku.external_ml.proxy_model.common.inputformat.base_writer import BaseWriter

logger = logging.getLogger(__name__)


def get_valid_input_formats(formats_to_try, client, input_df):
    """

    :param formats_to_try: 
    :type formats_to_try: list[type]
    :param client: 
    :param input_df: 
    :type input_df: pd.DataFrame
    :rtype: list[(BaseWriter, Any)]
    """
    from botocore.exceptions import ProxyConnectionError
    from azure.core.exceptions import ServiceRequestError

    exception_messages = []
    valid_formats_and_predictions = []

    for format_to_try in formats_to_try:
        f = format_to_try(client)
        logger.info("Trying with format: {} ".format(type(f)))
        predictions = None
        try:
            predictions = f.can_write(input_df)
        except ProxyConnectionError:
            logger.exception("Proxy related error")
            raise
        except ServiceRequestError:
            logger.exception("Error connection to cloud API")
            raise
        except Exception as e:
            message = "Exception while trying format: {}. Exception message: {}".format(format_to_try, e)
            logger.info(message)
            exception_messages.append(message)
        if predictions:
            # We also add the predictions so that we don't waste a call.
            valid_formats_and_predictions.append((f, predictions))
        else:
            logger.info("Format {} failed".format(format_to_try))

    if len(valid_formats_and_predictions) > 0:
        return valid_formats_and_predictions
    else:
        logger.error("No valid input format found.")
        raise ValueError("No valid input format found. Here is a list of all error messages encountered "
                         "while trying supported input formats: \n {}".format("\n".join(exception_messages)))
