/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.credential;

import java.time.Duration;
import java.time.OffsetDateTime;

public class AccessToken {
    private final String token;
    private final OffsetDateTime expiresAt;
    private final OffsetDateTime refreshAt;
    private final String tokenType;

    public AccessToken(String token, OffsetDateTime expiresAt) {
        this.token = token;
        this.expiresAt = expiresAt;
        this.refreshAt = null;
        this.tokenType = "Bearer";
    }

    public AccessToken(String token, OffsetDateTime expiresAt, OffsetDateTime refreshAt) {
        this.token = token;
        this.expiresAt = expiresAt;
        this.refreshAt = refreshAt;
        this.tokenType = "Bearer";
    }

    public AccessToken(String token, OffsetDateTime expiresAt, OffsetDateTime refreshAt, String tokenType) {
        this.token = token;
        this.expiresAt = expiresAt;
        this.refreshAt = refreshAt;
        this.tokenType = tokenType;
    }

    public String getToken() {
        return this.token;
    }

    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public OffsetDateTime getRefreshAt() {
        return this.refreshAt;
    }

    public boolean isExpired() {
        return OffsetDateTime.now().isAfter(this.expiresAt);
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public Duration getDurationUntilExpiration() {
        return Duration.between(this.expiresAt, OffsetDateTime.now()).negated();
    }
}

