/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.ImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.util.BinaryDataHelper;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.util.FluxByteBufferContent;
import com.dataiku.dss.shadelibazure.com.azure.core.util.BinaryData;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;

public class HttpRequest {
    private static final ClientLogger LOGGER = new ClientLogger(HttpRequest.class);
    private HttpMethod httpMethod;
    private URL url;
    private HttpHeaders headers;
    private BinaryData body;

    public HttpRequest(HttpMethod httpMethod, URL url) {
        this(httpMethod, url, new HttpHeaders(), (BinaryData)null);
    }

    public HttpRequest(HttpMethod httpMethod, String url) {
        this.httpMethod = httpMethod;
        this.setUrl(url);
        this.headers = new HttpHeaders();
    }

    public HttpRequest(HttpMethod httpMethod, URL url, HttpHeaders headers) {
        this.httpMethod = httpMethod;
        this.url = url;
        this.headers = headers;
    }

    public HttpRequest(HttpMethod httpMethod, URL url, HttpHeaders headers, Flux<ByteBuffer> body) {
        this.httpMethod = httpMethod;
        this.url = url;
        this.headers = headers;
        this.setBody(BinaryDataHelper.createBinaryData(new FluxByteBufferContent(body)));
    }

    public HttpRequest(HttpMethod httpMethod, URL url, HttpHeaders headers, BinaryData body) {
        this.httpMethod = httpMethod;
        this.url = url;
        this.headers = headers;
        this.setBody(body);
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public HttpRequest setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public URL getUrl() {
        return this.url;
    }

    public HttpRequest setUrl(URL url) {
        this.url = url;
        return this;
    }

    public HttpRequest setUrl(String url) {
        try {
            this.url = ImplUtils.createUrl(url);
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsWarning(new IllegalArgumentException("'url' must be a valid URL.", ex));
        }
        return this;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public HttpRequest setHeaders(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    @Deprecated
    public HttpRequest setHeader(String name, String value) {
        this.headers.set(name, value);
        return this;
    }

    public HttpRequest setHeader(HttpHeaderName headerName, String value) {
        this.headers.set(headerName, value);
        return this;
    }

    public Flux<ByteBuffer> getBody() {
        return this.body == null ? null : this.body.toFluxByteBuffer();
    }

    public BinaryData getBodyAsBinaryData() {
        return this.body;
    }

    public HttpRequest setBody(String content) {
        return this.setBody(BinaryData.fromString(content));
    }

    public HttpRequest setBody(byte[] content) {
        return this.setBody(BinaryData.fromBytes(content));
    }

    public HttpRequest setBody(Flux<ByteBuffer> content) {
        this.body = content != null ? BinaryDataHelper.createBinaryData(new FluxByteBufferContent(content)) : null;
        return this;
    }

    public HttpRequest setBody(BinaryData content) {
        this.body = content;
        if (content != null && content.getLength() != null) {
            this.setContentLength(content.getLength());
        }
        return this;
    }

    private void setContentLength(long contentLength) {
        this.headers.set(HttpHeaderName.CONTENT_LENGTH, String.valueOf(contentLength));
    }

    public HttpRequest copy() {
        HttpHeaders bufferedHeaders = new HttpHeaders(this.headers);
        return new HttpRequest(this.httpMethod, this.url, bufferedHeaders, this.body);
    }
}

